/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.AbstractRichIterable;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Procedures2;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.lazy.primitive.CollectBooleanIterable;
import com.gs.collections.impl.lazy.primitive.CollectByteIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharIterable;
import com.gs.collections.impl.lazy.primitive.CollectDoubleIterable;
import com.gs.collections.impl.lazy.primitive.CollectFloatIterable;
import com.gs.collections.impl.lazy.primitive.CollectIntIterable;
import com.gs.collections.impl.lazy.primitive.CollectLongIterable;
import com.gs.collections.impl.lazy.primitive.CollectShortIterable;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.utility.LazyIterate;
import java.util.Collection;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class AbstractLazyIterable<T>
extends AbstractRichIterable<T>
implements LazyIterable<T> {
    @Override
    public LazyIterable<T> asLazy() {
        return this;
    }

    @Override
    public <R extends Collection<T>> R into(R target) {
        this.forEachWith(Procedures2.addToCollection(), target);
        return target;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray(array);
    }

    @Override
    public int size() {
        return this.count(Predicates.alwaysTrue());
    }

    @Override
    public boolean isEmpty() {
        return !this.anySatisfy(Predicates.alwaysTrue());
    }

    @Override
    public T getFirst() {
        return (T)this.detect(Predicates.alwaysTrue());
    }

    @Override
    public T getLast() {
        final Object[] result = new Object[1];
        this.forEach(new Procedure<T>(){

            @Override
            public void value(T each) {
                result[0] = each;
            }
        });
        return (T)result[0];
    }

    @Override
    public LazyIterable<T> select(Predicate<? super T> predicate) {
        return LazyIterate.select(this, predicate);
    }

    @Override
    public <P> LazyIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return LazyIterate.select(this, Predicates.bind(predicate, parameter));
    }

    @Override
    public LazyIterable<T> reject(Predicate<? super T> predicate) {
        return LazyIterate.reject(this, predicate);
    }

    @Override
    public <P> LazyIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return LazyIterate.reject(this, Predicates.bind(predicate, parameter));
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<T>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.partition((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> LazyIterable<S> selectInstancesOf(Class<S> clazz) {
        return LazyIterate.selectInstancesOf(this, clazz);
    }

    @Override
    public <V> LazyIterable<V> collect(Function<? super T, ? extends V> function) {
        return LazyIterate.collect(this, function);
    }

    @Override
    public LazyBooleanIterable collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return new CollectBooleanIterable<T>(this, booleanFunction);
    }

    @Override
    public LazyByteIterable collectByte(ByteFunction<? super T> byteFunction) {
        return new CollectByteIterable<T>(this, byteFunction);
    }

    @Override
    public LazyCharIterable collectChar(CharFunction<? super T> charFunction) {
        return new CollectCharIterable<T>(this, charFunction);
    }

    @Override
    public LazyDoubleIterable collectDouble(DoubleFunction<? super T> doubleFunction) {
        return new CollectDoubleIterable<T>(this, doubleFunction);
    }

    @Override
    public LazyFloatIterable collectFloat(FloatFunction<? super T> floatFunction) {
        return new CollectFloatIterable<T>(this, floatFunction);
    }

    @Override
    public LazyIntIterable collectInt(IntFunction<? super T> intFunction) {
        return new CollectIntIterable<T>(this, intFunction);
    }

    @Override
    public LazyLongIterable collectLong(LongFunction<? super T> longFunction) {
        return new CollectLongIterable<T>(this, longFunction);
    }

    @Override
    public LazyShortIterable collectShort(ShortFunction<? super T> shortFunction) {
        return new CollectShortIterable<T>(this, shortFunction);
    }

    @Override
    public <P, V> LazyIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return LazyIterate.collect(this, Functions.bind(function, parameter));
    }

    @Override
    public <V> LazyIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return LazyIterate.flatCollect(this, function);
    }

    @Override
    public LazyIterable<T> concatenate(Iterable<T> iterable) {
        return LazyIterate.concatenate(this, iterable);
    }

    @Override
    public <V> LazyIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.collectIf(this, predicate, function);
    }

    @Override
    public LazyIterable<T> take(int count) {
        return LazyIterate.take(this, count);
    }

    @Override
    public LazyIterable<T> drop(int count) {
        return LazyIterate.drop(this, count);
    }

    @Override
    public LazyIterable<T> distinct() {
        return LazyIterate.distinct(this);
    }

    public MutableStack<T> toStack() {
        return ArrayStack.newStack(this);
    }

    @Override
    public <V> Multimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    @Override
    public <V> Multimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    @Override
    public <S> LazyIterable<Pair<T, S>> zip(Iterable<S> that) {
        return LazyIterate.zip(this, that);
    }

    @Override
    public LazyIterable<Pair<T, Integer>> zipWithIndex() {
        return LazyIterate.zipWithIndex(this);
    }

    @Override
    public LazyIterable<RichIterable<T>> chunk(int size) {
        return LazyIterate.chunk(this, size);
    }

    @Override
    public LazyIterable<T> tap(Procedure<? super T> procedure) {
        return LazyIterate.tap(this, procedure);
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }
}

