/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.collection.AbstractSynchronizedRichIterable;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractSynchronizedMutableCollection<T>
extends AbstractSynchronizedRichIterable<T>
implements MutableCollection<T> {
    protected AbstractSynchronizedMutableCollection(MutableCollection<T> delegate) {
        this(delegate, (Object)null);
    }

    protected AbstractSynchronizedMutableCollection(MutableCollection<T> delegate, Object lock) {
        super(delegate, lock);
    }

    @Override
    protected MutableCollection<T> getDelegate() {
        return (MutableCollection)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> coll) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().retainAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().removeIfWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().retainAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectAndRejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().injectIntoWith(injectValue, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
    }
}

