/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectLongMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.block.factory.PrimitiveFunctions;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiReaderMutableCollection<T>
implements MutableCollection<T> {
    protected abstract MutableCollection<T> getDelegate();

    protected abstract ReadWriteLock getLock();

    protected void acquireWriteLock() {
        this.getLock().writeLock().lock();
    }

    protected void unlockWriteLock() {
        this.getLock().writeLock().unlock();
    }

    protected void acquireReadLock() {
        this.getLock().readLock().lock();
    }

    protected void unlockReadLock() {
        this.getLock().readLock().unlock();
    }

    protected void withReadLockRun(Runnable block) {
        this.acquireReadLock();
        try {
            block.run();
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean contains(Object item) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().contains(item);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAll(collection);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAllIterable(source);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAllArguments(elements);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().noneSatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().noneSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().allSatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().allSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().anySatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().anySatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableList<T> toList() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toList();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableMap<? extends NK, ? extends NV> mutableMap = this.getDelegate().toMap(keyFunction, valueFunction);
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableSortedMap<? extends NK, ? extends NV> mutableSortedMap = this.getDelegate().toSortedMap(keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableSortedMap<? extends NK, ? extends NV> mutableSortedMap = this.getDelegate().toSortedMap(comparator, keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public LazyIterable<T> asLazy() {
        this.acquireReadLock();
        try {
            LazyIterable lazyIterable = this.getDelegate().asLazy();
            return lazyIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> toSet() {
        this.acquireReadLock();
        try {
            MutableSet mutableSet = this.getDelegate().toSet();
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> toBag() {
        this.acquireReadLock();
        try {
            MutableBag mutableBag = this.getDelegate().toBag();
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSortedBag<T> toSortedBag() {
        this.acquireReadLock();
        try {
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBag();
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableSortedBag<? super T> mutableSortedBag = this.getDelegate().toSortedBag(comparator);
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSortedBag<? super T> mutableSortedBag = this.getDelegate().toSortedBagBy(function);
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableList<T> toSortedList() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toSortedList();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableList<? super T> mutableList = this.getDelegate().toSortedList(comparator);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableList<? super T> mutableList = this.getDelegate().toSortedListBy(function);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        this.acquireReadLock();
        try {
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSet();
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableSortedSet<? super T> mutableSortedSet = this.getDelegate().toSortedSet(comparator);
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSortedSet<? super T> mutableSortedSet = this.getDelegate().toSortedSetBy(function);
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().count(predicate);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().countWith(predicate, parameter);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().detect(predicate);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().min(comparator);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().max(comparator);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T min() {
        this.acquireReadLock();
        try {
            Object t = this.getDelegate().min();
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T max() {
        this.acquireReadLock();
        try {
            Object t = this.getDelegate().max();
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().minBy(function);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().maxBy(function);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().detectIfNone(predicate, function);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().detectWith(predicate, parameter);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        this.acquireReadLock();
        try {
            T t = this.getDelegate().detectWithIfNone(predicate, parameter, function);
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T getFirst() {
        this.acquireReadLock();
        try {
            Object t = this.getDelegate().getFirst();
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public T getLast() {
        this.acquireReadLock();
        try {
            Object t = this.getDelegate().getLast();
            return t;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean notEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().notEmpty();
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            Twin<MutableList<T>> twin = this.getDelegate().selectAndRejectWith(predicate, parameter);
            return twin;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collect(function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectBoolean(booleanFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectByte(byteFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectChar(charFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectDouble(doubleFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectFloat(floatFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectInt(intFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectLong(longFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectShort(shortFunction, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().flatCollect(function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectIf(predicate, function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().collectWith(function, parameter, targetCollection);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().selectWith(predicate, parameter, targetCollection);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().reject(predicate, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().rejectWith(predicate, parameter, targetCollection);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().select(predicate, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        this.acquireReadLock();
        try {
            IV IV = this.getDelegate().injectInto(injectedValue, function);
            return IV;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().injectInto(injectedValue, function);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().injectInto(injectedValue, function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().injectInto(injectedValue, function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        this.acquireReadLock();
        try {
            float f = this.getDelegate().injectInto(injectedValue, function);
            return f;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfInt(IntFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().sumOfInt(function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfFloat(FloatFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().sumOfFloat(function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfLong(LongFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().sumOfLong(function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfDouble(DoubleFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().sumOfDouble(function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> ObjectLongMap<V> sumByInt(Function<T, V> groupBy, IntFunction<? super T> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    @Override
    public <V> ObjectDoubleMap<V> sumByFloat(Function<T, V> groupBy, FloatFunction<? super T> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    @Override
    public <V> ObjectLongMap<V> sumByLong(Function<T, V> groupBy, LongFunction<? super T> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    @Override
    public <V> ObjectDoubleMap<V> sumByDouble(Function<T, V> groupBy, DoubleFunction<? super T> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        this.acquireReadLock();
        try {
            IV IV = this.getDelegate().injectIntoWith(injectValue, function, parameter);
            return IV;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeIf(predicate);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeIfWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean add(T item) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().add(item);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().addAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().addAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public void clear() {
        this.acquireWriteLock();
        try {
            this.getDelegate().clear();
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().isEmpty();
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Iterator is not supported directly on MultiReader collections.  If you would like to use an iterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    @Override
    public boolean remove(Object item) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().remove(item);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().retainAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().retainAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public int size() {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().size();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public Object[] toArray() {
        this.acquireReadLock();
        try {
            Object[] objectArray = this.getDelegate().toArray();
            return objectArray;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <E> E[] toArray(E[] a) {
        this.acquireReadLock();
        try {
            E[] EArray = this.getDelegate().toArray(a);
            return EArray;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.each(procedure);
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEach(procedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEachWith(procedure, parameter);
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEachWithIndex(objectIntProcedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public String toString() {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().toString();
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public String makeString() {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString();
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public String makeString(String separator) {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString(separator);
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString(start, separator, end);
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void appendString(Appendable appendable) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable);
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable, separator);
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable, start, separator, end);
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().groupBy(function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().groupByEach(function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().groupByUniqueKey(function, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().zip(that, target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        this.acquireReadLock();
        try {
            R r = this.getDelegate().zipWithIndex(target);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    @Override
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class UntouchableMutableCollection<T>
    implements MutableCollection<T> {
        protected MutableCollection<T> delegate;

        protected UntouchableMutableCollection() {
        }

        @Override
        public boolean allSatisfy(Predicate<? super T> predicate) {
            return this.delegate.allSatisfy(predicate);
        }

        @Override
        public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.allSatisfyWith(predicate, parameter);
        }

        @Override
        public boolean noneSatisfy(Predicate<? super T> predicate) {
            return this.delegate.noneSatisfy(predicate);
        }

        @Override
        public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.noneSatisfyWith(predicate, parameter);
        }

        @Override
        public boolean anySatisfy(Predicate<? super T> predicate) {
            return this.delegate.anySatisfy(predicate);
        }

        @Override
        public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.anySatisfyWith(predicate, parameter);
        }

        @Override
        public MutableList<T> toList() {
            return this.delegate.toList();
        }

        @Override
        public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toMap(keyFunction, valueFunction);
        }

        @Override
        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(keyFunction, valueFunction);
        }

        @Override
        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
        }

        @Override
        public MutableSet<T> toSet() {
            return this.delegate.toSet();
        }

        @Override
        public MutableBag<T> toBag() {
            return this.delegate.toBag();
        }

        @Override
        public MutableSortedBag<T> toSortedBag() {
            return this.delegate.toSortedBag();
        }

        @Override
        public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
            return this.delegate.toSortedBag(comparator);
        }

        @Override
        public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedBagBy(function);
        }

        @Override
        public MutableList<T> toSortedList() {
            return this.delegate.toSortedList();
        }

        @Override
        public MutableList<T> toSortedList(Comparator<? super T> comparator) {
            return this.delegate.toSortedList(comparator);
        }

        @Override
        public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedListBy(function);
        }

        @Override
        public MutableSortedSet<T> toSortedSet() {
            return this.delegate.toSortedSet();
        }

        @Override
        public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
            return this.delegate.toSortedSet(comparator);
        }

        @Override
        public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedSetBy(function);
        }

        @Override
        public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
            return this.delegate.collect(function, target);
        }

        @Override
        public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
            return this.delegate.flatCollect(function, target);
        }

        @Override
        public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
            return this.delegate.collectIf(predicate, function, target);
        }

        @Override
        public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
            return this.delegate.collectWith(function, parameter, targetCollection);
        }

        @Override
        public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
            return this.delegate.groupBy(function, target);
        }

        @Override
        public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
            return this.delegate.groupByEach(function, target);
        }

        @Override
        public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
            return this.delegate.groupByUniqueKey(function, target);
        }

        @Override
        public int count(Predicate<? super T> predicate) {
            return this.delegate.count(predicate);
        }

        @Override
        public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.countWith(predicate, parameter);
        }

        @Override
        public T detect(Predicate<? super T> predicate) {
            return this.delegate.detect(predicate);
        }

        @Override
        public T min(Comparator<? super T> comparator) {
            return this.delegate.min(comparator);
        }

        @Override
        public T max(Comparator<? super T> comparator) {
            return this.delegate.max(comparator);
        }

        @Override
        public T min() {
            return this.delegate.min();
        }

        @Override
        public T max() {
            return this.delegate.max();
        }

        @Override
        public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
            return this.delegate.minBy(function);
        }

        @Override
        public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
            return this.delegate.maxBy(function);
        }

        @Override
        public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
            return this.delegate.detectIfNone(predicate, function);
        }

        @Override
        public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.detectWith(predicate, parameter);
        }

        @Override
        public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
            return this.delegate.detectWithIfNone(predicate, parameter, function);
        }

        @Override
        public T getFirst() {
            return this.delegate.getFirst();
        }

        @Override
        public T getLast() {
            return this.delegate.getLast();
        }

        @Override
        public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        @Override
        public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        @Override
        public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        @Override
        public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        @Override
        public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        @Override
        public long sumOfInt(IntFunction<? super T> function) {
            return this.delegate.sumOfInt(function);
        }

        @Override
        public double sumOfFloat(FloatFunction<? super T> function) {
            return this.delegate.sumOfFloat(function);
        }

        @Override
        public long sumOfLong(LongFunction<? super T> function) {
            return this.delegate.sumOfLong(function);
        }

        @Override
        public double sumOfDouble(DoubleFunction<? super T> function) {
            return this.delegate.sumOfDouble(function);
        }

        @Override
        public <V> ObjectLongMap<V> sumByInt(Function<T, V> groupBy, IntFunction<? super T> function) {
            return this.delegate.sumByInt(groupBy, function);
        }

        @Override
        public <V> ObjectDoubleMap<V> sumByFloat(Function<T, V> groupBy, FloatFunction<? super T> function) {
            return this.delegate.sumByFloat(groupBy, function);
        }

        @Override
        public <V> ObjectLongMap<V> sumByLong(Function<T, V> groupBy, LongFunction<? super T> function) {
            return this.delegate.sumByLong(groupBy, function);
        }

        @Override
        public <V> ObjectDoubleMap<V> sumByDouble(Function<T, V> groupBy, DoubleFunction<? super T> function) {
            return this.delegate.sumByDouble(groupBy, function);
        }

        @Override
        public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
            return this.delegate.injectIntoWith(injectValue, function, parameter);
        }

        @Override
        public boolean notEmpty() {
            return this.delegate.notEmpty();
        }

        @Override
        public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
            return this.delegate.reject(predicate, target);
        }

        @Override
        public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return this.delegate.rejectWith(predicate, parameter, targetCollection);
        }

        @Override
        public boolean removeIf(Predicate<? super T> predicate) {
            return this.delegate.removeIf(predicate);
        }

        @Override
        public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.removeIfWith(predicate, parameter);
        }

        @Override
        public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
            return this.delegate.select(predicate, target);
        }

        @Override
        public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.selectAndRejectWith(predicate, parameter);
        }

        @Override
        public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return this.delegate.selectWith(predicate, parameter, targetCollection);
        }

        @Override
        public boolean add(T o) {
            return this.delegate.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean addAllIterable(Iterable<? extends T> iterable) {
            return this.delegate.addAllIterable(iterable);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean containsAllIterable(Iterable<?> source) {
            return this.delegate.containsAllIterable(source);
        }

        @Override
        public boolean containsAllArguments(Object ... elements) {
            return this.delegate.containsAllArguments(elements);
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean removeAllIterable(Iterable<?> iterable) {
            return this.delegate.removeAllIterable(iterable);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        @Override
        public boolean retainAllIterable(Iterable<?> iterable) {
            return this.delegate.retainAllIterable(iterable);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public void forEach(Procedure<? super T> procedure) {
            this.each(procedure);
        }

        @Override
        public void each(Procedure<? super T> procedure) {
            this.delegate.forEach(procedure);
        }

        @Override
        public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
            this.delegate.forEachWith(procedure, parameter);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
            this.delegate.forEachWithIndex(objectIntProcedure);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String makeString() {
            return this.delegate.makeString();
        }

        @Override
        public String makeString(String separator) {
            return this.delegate.makeString(separator);
        }

        @Override
        public String makeString(String start, String separator, String end) {
            return this.delegate.makeString(start, separator, end);
        }

        @Override
        public void appendString(Appendable appendable) {
            this.delegate.appendString(appendable);
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.delegate.appendString(appendable, separator);
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            this.delegate.appendString(appendable, start, separator, end);
        }

        @Override
        public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
            return this.delegate.zip(that, target);
        }

        @Override
        public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
            return this.delegate.zipWithIndex(target);
        }

        @Override
        public RichIterable<RichIterable<T>> chunk(int size) {
            return this.delegate.chunk(size);
        }

        @Override
        public <K, V> MutableMap<K, V> aggregateInPlaceBy(final Function<? super T, ? extends K> groupBy, final Function0<? extends V> zeroValueFactory, final Procedure2<? super V, ? super T> mutatingAggregator) {
            final UnifiedMap map = UnifiedMap.newMap();
            this.forEach(new Procedure<T>(){

                @Override
                public void value(T each) {
                    Object key = groupBy.valueOf(each);
                    Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
                    mutatingAggregator.value(value, each);
                }
            });
            return map;
        }

        @Override
        public <K, V> MutableMap<K, V> aggregateBy(final Function<? super T, ? extends K> groupBy, final Function0<? extends V> zeroValueFactory, final Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
            final UnifiedMap map = UnifiedMap.newMap();
            this.forEach(new Procedure<T>(){

                @Override
                public void value(T each) {
                    Object key = groupBy.valueOf(each);
                    Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
                    map.put(key, nonMutatingAggregator.value(value, each));
                }
            });
            return map;
        }
    }
}

