/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.procedure;

import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.procedure.DoubleSumResultHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumOfFloatProcedure<T>
implements Procedure<T>,
DoubleSumResultHolder {
    private static final long serialVersionUID = 2L;
    private final FloatFunction<? super T> function;
    private double result;
    private double compensation;

    public SumOfFloatProcedure(FloatFunction<? super T> function) {
        this.function = function;
    }

    @Override
    public double getResult() {
        return this.result;
    }

    @Override
    public double getCompensation() {
        return this.compensation;
    }

    @Override
    public void value(T each) {
        double adjustedValue = (double)this.function.floatValueOf(each) - this.compensation;
        double nextSum = this.result + adjustedValue;
        this.compensation = nextSum - this.result - adjustedValue;
        this.result = nextSum;
    }
}

