/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.procedure;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.list.mutable.FastList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectIfProcedure<T, V>
implements Procedure<T> {
    private static final long serialVersionUID = 1L;
    private final Function<? super T, ? extends V> function;
    private final Predicate<? super T> predicate;
    private final Collection<V> collection;

    public CollectIfProcedure(int taskSize, Function<? super T, ? extends V> function, Predicate<? super T> predicate) {
        this(FastList.newList(taskSize), function, predicate);
    }

    public CollectIfProcedure(Collection<V> targetCollection, Function<? super T, ? extends V> function, Predicate<? super T> predicate) {
        this.function = function;
        this.predicate = predicate;
        this.collection = targetCollection;
    }

    @Override
    public void value(T object) {
        if (this.predicate.accept(object)) {
            this.collection.add(this.function.valueOf(object));
        }
    }

    public Collection<V> getCollection() {
        return this.collection;
    }
}

