/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.block.procedure.checked.ThrowingProcedure2;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Procedures2 {
    public static final Procedure2<?, ?> ADD_TO_COLLECTION = new AddToCollection();
    public static final Procedure2<?, ?> REMOVE_FROM_COLLECTION = new RemoveFromCollection();

    private Procedures2() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T, P> Procedure2<T, P> throwing(ThrowingProcedure2<T, P> throwingProcedure2) {
        return new ThrowingProcedure2Adapter(throwingProcedure2);
    }

    public static <T, P> Procedure2<T, P> fromProcedure(Procedure<? super T> procedure) {
        return new ProcedureAdapter(procedure);
    }

    public static <T> Procedure2<T, Collection<T>> addToCollection() {
        return ADD_TO_COLLECTION;
    }

    public static <T> Procedure2<T, Collection<T>> removeFromCollection() {
        return REMOVE_FROM_COLLECTION;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThrowingProcedure2Adapter<T, P>
    extends CheckedProcedure2<T, P> {
        private static final long serialVersionUID = 1L;
        private final ThrowingProcedure2<T, P> throwingProcedure2;

        private ThrowingProcedure2Adapter(ThrowingProcedure2<T, P> throwingProcedure2) {
            this.throwingProcedure2 = throwingProcedure2;
        }

        @Override
        public void safeValue(T object, P parameter) throws Exception {
            this.throwingProcedure2.safeValue(object, parameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveFromCollection<T>
    implements Procedure2<T, Collection<T>> {
        private static final long serialVersionUID = 1L;

        private RemoveFromCollection() {
        }

        @Override
        public void value(T each, Collection<T> target) {
            target.remove(each);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddToCollection<T>
    implements Procedure2<T, Collection<T>> {
        private static final long serialVersionUID = 1L;

        private AddToCollection() {
        }

        @Override
        public void value(T each, Collection<T> target) {
            target.add(each);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcedureAdapter<T, P>
    implements Procedure2<T, P> {
        private static final long serialVersionUID = 1L;
        private final Procedure<? super T> procedure;

        private ProcedureAdapter(Procedure<? super T> procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(T each, P parameter) {
            this.procedure.value(each);
        }
    }
}

