/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.block.factory.Predicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongPredicates {
    private static final Predicates<Long> IS_ODD = new LongIsOdd();
    private static final Predicates<Long> IS_EVEN = new LongIsEven();
    private static final Predicates<Long> IS_POSITIVE = new LongIsPositive();
    private static final Predicates<Long> IS_NEGATIVE = new LongIsNegative();
    private static final Predicates<Long> IS_ZERO = new LongIsZero();

    private LongPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Predicates<Long> isOdd() {
        return IS_ODD;
    }

    public static Predicates<Long> isEven() {
        return IS_EVEN;
    }

    public static Predicates<Long> isPositive() {
        return IS_POSITIVE;
    }

    public static Predicates<Long> isNegative() {
        return IS_NEGATIVE;
    }

    public static Predicates<Long> isZero() {
        return IS_ZERO;
    }

    public static <T> Predicates<T> attributeIsEven(Function<T, Long> function) {
        return Predicates.attributePredicate(function, LongPredicates.isEven());
    }

    public static <T> Predicates<T> attributeIsOdd(Function<T, Long> function) {
        return Predicates.attributePredicate(function, LongPredicates.isOdd());
    }

    public static <T> Predicates<T> attributeIsZero(Function<T, Long> function) {
        return Predicates.attributePredicate(function, LongPredicates.isZero());
    }

    public static <T> Predicates<T> attributeIsPositive(Function<T, Long> function) {
        return Predicates.attributePredicate(function, LongPredicates.isPositive());
    }

    public static <T> Predicates<T> attributeIsNegative(Function<T, Long> function) {
        return Predicates.attributePredicate(function, LongPredicates.isNegative());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongIsZero
    extends Predicates<Long> {
        private static final long serialVersionUID = 1L;

        private LongIsZero() {
        }

        @Override
        public boolean accept(Long l) {
            return l == 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongIsNegative
    extends Predicates<Long> {
        private static final long serialVersionUID = 1L;

        private LongIsNegative() {
        }

        @Override
        public boolean accept(Long l) {
            return l < 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongIsPositive
    extends Predicates<Long> {
        private static final long serialVersionUID = 1L;

        private LongIsPositive() {
        }

        @Override
        public boolean accept(Long l) {
            return l > 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongIsEven
    extends Predicates<Long> {
        private static final long serialVersionUID = 1L;

        private LongIsEven() {
        }

        @Override
        public boolean accept(Long l) {
            return l % 2L == 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongIsOdd
    extends Predicates<Long> {
        private static final long serialVersionUID = 1L;

        private LongIsOdd() {
        }

        @Override
        public boolean accept(Long l) {
            return l % 2L != 0L;
        }
    }
}

