/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.block.factory.Predicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerPredicates {
    private static final Predicates<Integer> IS_ODD = new IntegerIsOdd();
    private static final Predicates<Integer> IS_EVEN = new IntegerIsEven();
    private static final Predicates<Integer> IS_POSITIVE = new IntegerIsPositive();
    private static final Predicates<Integer> IS_NEGATIVE = new IntegerIsNegative();
    private static final Predicates<Integer> IS_ZERO = new IntegerIsZero();

    private IntegerPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Predicates<Integer> isOdd() {
        return IS_ODD;
    }

    public static Predicates<Integer> isEven() {
        return IS_EVEN;
    }

    public static Predicates<Integer> isPositive() {
        return IS_POSITIVE;
    }

    public static Predicates<Integer> isNegative() {
        return IS_NEGATIVE;
    }

    public static Predicates<Integer> isZero() {
        return IS_ZERO;
    }

    public static <T> Predicates<T> attributeIsEven(Function<T, Integer> function) {
        return Predicates.attributePredicate(function, IntegerPredicates.isEven());
    }

    public static <T> Predicates<T> attributeIsOdd(Function<T, Integer> function) {
        return Predicates.attributePredicate(function, IntegerPredicates.isOdd());
    }

    public static <T> Predicates<T> attributeIsZero(Function<T, Integer> function) {
        return Predicates.attributePredicate(function, IntegerPredicates.isZero());
    }

    public static <T> Predicates<T> attributeIsPositive(Function<T, Integer> function) {
        return Predicates.attributePredicate(function, IntegerPredicates.isPositive());
    }

    public static <T> Predicates<T> attributeIsNegative(Function<T, Integer> function) {
        return Predicates.attributePredicate(function, IntegerPredicates.isNegative());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsEven
    extends Predicates<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsEven() {
        }

        @Override
        public boolean accept(Integer i) {
            return i % 2 == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsOdd
    extends Predicates<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsOdd() {
        }

        @Override
        public boolean accept(Integer i) {
            return i % 2 != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsZero
    extends Predicates<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsZero() {
        }

        @Override
        public boolean accept(Integer i) {
            return i == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsNegative
    extends Predicates<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsNegative() {
        }

        @Override
        public boolean accept(Integer i) {
            return i < 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsPositive
    extends Predicates<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsPositive() {
        }

        @Override
        public boolean accept(Integer i) {
            return i > 0;
        }
    }
}

