/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.sorted.immutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.sorted.ImmutableSortedBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableBooleanList;
import com.gs.collections.api.list.primitive.ImmutableByteList;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.api.list.primitive.ImmutableFloatList;
import com.gs.collections.api.list.primitive.ImmutableIntList;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import com.gs.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import com.gs.collections.api.set.sorted.ImmutableSortedSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;
import com.gs.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import com.gs.collections.impl.bag.sorted.immutable.ImmutableSortedBagSerializationProxy;
import com.gs.collections.impl.bag.sorted.mutable.TreeBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.bag.sorted.mutable.TreeBagMultimap;
import com.gs.collections.impl.partition.bag.sorted.PartitionTreeBag;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.Iterate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
abstract class AbstractImmutableSortedBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableSortedBag<T> {
    AbstractImmutableSortedBag() {
    }

    @Override
    public ImmutableSortedBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject(Predicates.in(elements));
    }

    @Override
    public ImmutableSortedBag<T> toImmutable() {
        return this;
    }

    @Override
    public ImmutableSortedBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    protected Object writeReplace() {
        return new ImmutableSortedBagSerializationProxy(this);
    }

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap()).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    @Override
    public <P> ImmutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    @Override
    public <P> ImmutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    @Override
    public PartitionImmutableSortedBag<T> partition(final Predicate<? super T> predicate) {
        final PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int index) {
                MutableSortedBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result.toImmutable();
    }

    @Override
    public <P> PartitionImmutableSortedBag<T> partitionWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int index) {
                MutableSortedBag bucket = predicate.accept(each, parameter) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, FastList.newList()).toImmutable();
    }

    @Override
    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, FastList.newList()).toImmutable();
    }

    @Override
    public <V> ImmutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, FastList.newList()).toImmutable();
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongArrayList(this.size())).toImmutable();
    }

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortArrayList(this.size())).toImmutable();
    }

    @Override
    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, FastList.newList()).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> selectByOccurrences(final IntPredicate predicate) {
        final TreeBag result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int occurrences) {
                if (predicate.accept(occurrences)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    @Override
    public <S> ImmutableSortedBag<S> selectInstancesOf(final Class<S> clazz) {
        Comparator comparator = this.comparator();
        final TreeBag result = TreeBag.newBag(comparator);
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int occurrences) {
                if (clazz.isInstance(each)) {
                    result.addOccurrences(clazz.cast(each), occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    @Override
    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> that) {
        final FastList list = FastList.newList();
        final Iterator<S> iterator = that.iterator();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int parameter) {
                for (int i = 0; i < parameter; ++i) {
                    if (!iterator.hasNext()) continue;
                    list.add(Tuples.pair(each, iterator.next()));
                }
            }
        });
        return list.toImmutable();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, final R target) {
        final Iterator<S> iterator = that.iterator();
        if (target instanceof MutableBag) {
            final MutableBag targetBag = (MutableBag)target;
            this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

                @Override
                public void value(T each, int occurrences) {
                    if (iterator.hasNext()) {
                        targetBag.addOccurrences(Tuples.pair(each, iterator.next()), occurrences);
                    }
                }
            });
        } else {
            this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

                @Override
                public void value(T each, int occurrences) {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!iterator.hasNext()) continue;
                        target.add(Tuples.pair(each, iterator.next()));
                    }
                }
            });
        }
        return target;
    }

    @Override
    public ImmutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        Comparator comparator = this.comparator() == null ? Comparators.naturalOrder() : this.comparator();
        TreeSortedSet pairs = TreeSortedSet.newSet(Comparators.chain(Comparators.byFunction(Functions.firstOfPair(), comparator), Comparators.byFunction(Functions.secondOfPair())));
        return Iterate.zipWithIndex(this, pairs).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        return this.occurrencesSortingBy(n, new IntFunction<ObjectIntPair<T>>(){

            @Override
            public int intValueOf(ObjectIntPair<T> item) {
                return -item.getTwo();
            }
        }).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        return this.occurrencesSortingBy(n, new IntFunction<ObjectIntPair<T>>(){

            @Override
            public int intValueOf(ObjectIntPair<T> item) {
                return item.getTwo();
            }
        }).toImmutable();
    }

    private MutableList<ObjectIntPair<T>> occurrencesSortingBy(int n, IntFunction<ObjectIntPair<T>> function) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return Lists.fixedSize.empty();
        }
        MutableList<ObjectIntPair<T>> sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList<ObjectIntPair<T>> results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((ObjectIntPair)results.getLast()).getTwo() == ((ObjectIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    @Override
    public MutableStack<T> toStack() {
        return Stacks.mutable.withAll(this);
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        Object[] objects = this.toArray();
        TreeBag batch = TreeBag.newBag(this.comparator());
        int j = 0;
        while (j < objects.length) {
            for (int i = 0; i < size && j < objects.length; ++j, ++i) {
                batch.add(objects[j]);
            }
            result.add(batch.toImmutable());
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    @Override
    public int detectLastIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    @Override
    public void reverseForEach(Procedure<? super T> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reverseForEach() not implemented yet");
    }

    @Override
    public LazyIterable<T> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }
}

