/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableIntBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedIntCollection;
import com.gs.collections.impl.factory.primitive.IntBags;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedIntBag
extends AbstractSynchronizedIntCollection
implements MutableIntBag {
    private static final long serialVersionUID = 1L;

    SynchronizedIntBag(MutableIntBag bag) {
        super(bag);
    }

    SynchronizedIntBag(MutableIntBag bag, Object newLock) {
        super(bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableIntBag getMutableIntBag() {
        return (MutableIntBag)this.getIntCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntBag with(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntBag without(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntBag withAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntBag withoutAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOccurrences(int item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(int item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(int item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(IntIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag select(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag reject(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIntIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyIntIterableAdapter(this);
        }
    }

    @Override
    public MutableIntBag asUnmodifiable() {
        return new UnmodifiableIntBag(this);
    }

    @Override
    public MutableIntBag asSynchronized() {
        return this;
    }

    @Override
    public ImmutableIntBag toImmutable() {
        return IntBags.immutable.withAll(this);
    }
}

