/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanIntProcedure;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableBooleanBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedBooleanCollection;
import com.gs.collections.impl.factory.primitive.BooleanBags;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedBooleanBag
extends AbstractSynchronizedBooleanCollection
implements MutableBooleanBag {
    private static final long serialVersionUID = 1L;

    SynchronizedBooleanBag(MutableBooleanBag bag) {
        super(bag);
    }

    SynchronizedBooleanBag(MutableBooleanBag bag, Object newLock) {
        super(bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableBooleanBag getMutableBooleanBag() {
        return (MutableBooleanBag)this.getBooleanCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag with(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag without(boolean element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag withAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedBooleanBag withoutAll(BooleanIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOccurrences(boolean item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(boolean item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(boolean item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(BooleanIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBooleanBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanBag select(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanBag reject(BooleanPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBooleanBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyBooleanIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyBooleanIterableAdapter(this);
        }
    }

    @Override
    public MutableBooleanBag asUnmodifiable() {
        return new UnmodifiableBooleanBag(this);
    }

    @Override
    public MutableBooleanBag asSynchronized() {
        return this;
    }

    @Override
    public ImmutableBooleanBag toImmutable() {
        return BooleanBags.immutable.withAll(this);
    }
}

