/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.DoubleBag;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.MutableDoubleIterator;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.SynchronizedDoubleBag;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableDoubleBag;
import com.gs.collections.impl.block.factory.primitive.IntToIntFunctions;
import com.gs.collections.impl.factory.primitive.DoubleBags;
import com.gs.collections.impl.map.mutable.primitive.DoubleIntHashMap;
import com.gs.collections.impl.primitive.AbstractDoubleIterable;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class DoubleHashBag
extends AbstractDoubleIterable
implements MutableDoubleBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private DoubleIntHashMap items;
    private int size;

    public DoubleHashBag() {
        this.items = new DoubleIntHashMap();
    }

    public DoubleHashBag(int size) {
        this.items = new DoubleIntHashMap(size);
    }

    public DoubleHashBag(DoubleIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public DoubleHashBag(double ... elements) {
        this();
        this.addAll(elements);
    }

    public DoubleHashBag(DoubleHashBag bag) {
        this.items = new DoubleIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static DoubleHashBag newBag(int size) {
        return new DoubleHashBag(size);
    }

    public static DoubleHashBag newBagWith(double ... source) {
        return new DoubleHashBag(source);
    }

    public static DoubleHashBag newBag(DoubleIterable source) {
        if (source instanceof DoubleHashBag) {
            return new DoubleHashBag((DoubleHashBag)source);
        }
        return new DoubleHashBag(source);
    }

    public static DoubleHashBag newBag(DoubleBag source) {
        return new DoubleHashBag(source);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int sizeDistinct() {
        return this.items.size();
    }

    @Override
    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    @Override
    public DoubleHashBag with(double element) {
        this.add(element);
        return this;
    }

    public DoubleHashBag with(double element1, double element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public DoubleHashBag with(double element1, double element2, double element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    @Override
    public DoubleHashBag withAll(DoubleIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    @Override
    public DoubleHashBag without(double element) {
        this.remove(element);
        return this;
    }

    @Override
    public DoubleHashBag withoutAll(DoubleIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    @Override
    public boolean contains(double value) {
        return this.items.containsKey(value);
    }

    @Override
    public int occurrencesOf(double item) {
        return this.items.get(item);
    }

    @Override
    public void forEachWithOccurrences(DoubleIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    @Override
    public boolean add(double item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(double item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean addAll(double ... source) {
        if (source.length == 0) {
            return false;
        }
        for (double each : source) {
            this.add(each);
        }
        return true;
    }

    @Override
    public boolean addAll(DoubleIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof DoubleBag) {
            DoubleBag otherBag = (DoubleBag)source;
            otherBag.forEachWithOccurrences(new DoubleIntProcedure(){

                public void value(double each, int occurrences) {
                    DoubleHashBag.this.addOccurrences(each, occurrences);
                }
            });
        } else {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                double each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    @Override
    public boolean removeAll(double ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (double each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(DoubleIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof DoubleBag) {
            DoubleBag otherBag = (DoubleBag)source;
            otherBag.forEachWithOccurrences(new DoubleIntProcedure(){

                public void value(double each, int occurrences) {
                    int oldOccurrences = DoubleHashBag.this.items.removeKeyIfAbsent(each, 0);
                    DoubleHashBag doubleHashBag = DoubleHashBag.this;
                    doubleHashBag.size = doubleHashBag.size - oldOccurrences;
                }
            });
        } else {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                double each = iterator.next();
                int occurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= occurrences;
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(DoubleIterable source) {
        int oldSize = this.size();
        final DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
        DoubleHashBag retained = this.select(new DoublePredicate(){

            public boolean accept(double key) {
                return sourceSet.contains(key);
            }
        });
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(double ... source) {
        return this.retainAll(DoubleHashSet.newSetWith(source));
    }

    @Override
    public void addOccurrences(double item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, new IntToIntFunction(){

                public int valueOf(int intParameter) {
                    return intParameter + occurrences;
                }
            });
            this.size += occurrences;
        }
    }

    @Override
    public boolean removeOccurrences(double item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, new IntToIntFunction(){

            public int valueOf(int intParameter) {
                return intParameter - occurrences;
            }
        });
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(final DoubleProcedure procedure) {
        this.items.forEachKeyValue(new DoubleIntProcedure(){

            public void value(double key, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    @Override
    public DoubleHashBag select(final DoublePredicate predicate) {
        final DoubleHashBag result = new DoubleHashBag();
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public DoubleHashBag reject(final DoublePredicate predicate) {
        final DoubleHashBag result = new DoubleHashBag();
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        MutableDoubleIterator it = this.doubleIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    @Override
    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof DoubleBag)) {
            return false;
        }
        final DoubleBag bag = (DoubleBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(new DoublePredicate(){

            public boolean accept(double key) {
                return DoubleHashBag.this.occurrencesOf(key) == bag.occurrencesOf(key);
            }
        });
    }

    @Override
    public int hashCode() {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double eachItem, int occurrences) {
                result.add((int)(Double.doubleToLongBits(eachItem) ^ Double.doubleToLongBits(eachItem) >>> 32) ^ occurrences);
            }
        });
        return result.getCount();
    }

    @Override
    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        final boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue(new DoubleIntProcedure(){

                public void value(double each, int occurrences) {
                    try {
                        for (int i = 0; i < occurrences; ++i) {
                            if (!firstItem[0]) {
                                appendable.append(separator);
                            }
                            appendable.append(String.valueOf(each));
                            firstItem[0] = false;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count(final DoublePredicate predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                if (predicate.accept(each)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableBag<V> collect(final DoubleToObjectFunction<? extends V> function) {
        final HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                result.addOccurrences(function.valueOf(each), occurrences);
            }
        });
        return result;
    }

    @Override
    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    @Override
    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    @Override
    public double sum() {
        final double[] result = new double[]{0.0};
        final double[] compensation = new double[]{0.0};
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    double adjustedValue = each - compensation[0];
                    double nextSum = result[0] + adjustedValue;
                    compensation[0] = nextSum - result[0] - adjustedValue;
                    result[0] = nextSum;
                }
            }
        });
        return result[0];
    }

    @Override
    public double[] toArray() {
        final double[] array = new double[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new DoubleIntProcedure(){

            public void value(double each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    @Override
    public MutableDoubleBag asUnmodifiable() {
        return new UnmodifiableDoubleBag(this);
    }

    @Override
    public MutableDoubleBag asSynchronized() {
        return new SynchronizedDoubleBag(this);
    }

    @Override
    public ImmutableDoubleBag toImmutable() {
        return DoubleBags.immutable.withAll(this);
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue(new DoubleIntProcedure(){

                public void value(double each, int occurrences) {
                    try {
                        out.writeDouble(each);
                        out.writeInt(occurrences);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new DoubleIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readDouble(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableDoubleIterator {
        private final MutableDoubleIterator doubleIterator;
        private double currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.doubleIterator = DoubleHashBag.this.items.keySet().doubleIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.doubleIterator.hasNext();
        }

        public double next() {
            if (this.occurrences == 0) {
                this.currentItem = this.doubleIterator.next();
                this.occurrences = DoubleHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.doubleIterator.remove();
                DoubleHashBag.this.size--;
            } else {
                DoubleHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

