/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.BooleanBag;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanIntProcedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.MutableBooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.SynchronizedBooleanBag;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableBooleanBag;
import com.gs.collections.impl.factory.primitive.BooleanBags;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class BooleanHashBag
implements MutableBooleanBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int falseCount;
    private int trueCount;

    public BooleanHashBag() {
    }

    public BooleanHashBag(BooleanIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public BooleanHashBag(boolean ... elements) {
        this();
        this.addAll(elements);
    }

    public BooleanHashBag(BooleanHashBag bag) {
        this.falseCount = bag.falseCount;
        this.trueCount = bag.trueCount;
    }

    public static BooleanHashBag newBagWith(boolean ... source) {
        BooleanHashBag result = new BooleanHashBag();
        result.addAll(source);
        return result;
    }

    public static BooleanHashBag newBag(BooleanIterable source) {
        if (source instanceof BooleanHashBag) {
            return new BooleanHashBag((BooleanHashBag)source);
        }
        return new BooleanHashBag(source);
    }

    private boolean containsFalse() {
        return this.falseCount > 0;
    }

    private boolean containsTrue() {
        return this.trueCount > 0;
    }

    @Override
    public boolean isEmpty() {
        return !this.containsFalse() && !this.containsTrue();
    }

    @Override
    public boolean notEmpty() {
        return this.containsFalse() || this.containsTrue();
    }

    @Override
    public int size() {
        return this.falseCount + this.trueCount;
    }

    @Override
    public int sizeDistinct() {
        return (this.containsFalse() ? 1 : 0) + (this.containsTrue() ? 1 : 0);
    }

    @Override
    public void clear() {
        this.falseCount = 0;
        this.trueCount = 0;
    }

    @Override
    public BooleanHashBag with(boolean element) {
        this.add(element);
        return this;
    }

    public BooleanHashBag with(boolean element1, boolean element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public BooleanHashBag with(boolean element1, boolean element2, boolean element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    @Override
    public BooleanHashBag withAll(BooleanIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    @Override
    public BooleanHashBag without(boolean element) {
        this.remove(element);
        return this;
    }

    @Override
    public BooleanHashBag withoutAll(BooleanIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    @Override
    public MutableBooleanBag asUnmodifiable() {
        return new UnmodifiableBooleanBag(this);
    }

    @Override
    public MutableBooleanBag asSynchronized() {
        return new SynchronizedBooleanBag(this);
    }

    @Override
    public ImmutableBooleanBag toImmutable() {
        return BooleanBags.immutable.withAll(this);
    }

    @Override
    public boolean contains(boolean value) {
        return value ? this.containsTrue() : this.containsFalse();
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean each) {
                return BooleanHashBag.this.contains(each);
            }
        });
    }

    @Override
    public int occurrencesOf(boolean item) {
        return item ? this.trueCount : this.falseCount;
    }

    @Override
    public void forEachWithOccurrences(BooleanIntProcedure procedure) {
        if (this.containsFalse()) {
            procedure.value(false, this.falseCount);
        }
        if (this.containsTrue()) {
            procedure.value(true, this.trueCount);
        }
    }

    @Override
    public boolean add(boolean item) {
        if (item) {
            ++this.trueCount;
        } else {
            ++this.falseCount;
        }
        return true;
    }

    @Override
    public boolean remove(boolean item) {
        if (item) {
            if (!this.containsTrue()) {
                return false;
            }
            --this.trueCount;
        } else {
            if (!this.containsFalse()) {
                return false;
            }
            --this.falseCount;
        }
        return true;
    }

    @Override
    public boolean addAll(boolean ... source) {
        if (source.length < 1) {
            return false;
        }
        for (boolean each : source) {
            this.add(each);
        }
        return true;
    }

    @Override
    public boolean addAll(BooleanIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof BooleanBag) {
            BooleanBag otherBag = (BooleanBag)source;
            otherBag.forEachWithOccurrences(new BooleanIntProcedure(){

                public void value(boolean each, int occurrences) {
                    BooleanHashBag.this.addOccurrences(each, occurrences);
                }
            });
        } else {
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                boolean each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    @Override
    public boolean removeAll(boolean ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (boolean each : source) {
            if (each) {
                this.trueCount = 0;
                continue;
            }
            this.falseCount = 0;
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(BooleanIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof BooleanBag) {
            BooleanBag otherBag = (BooleanBag)source;
            otherBag.forEachWithOccurrences(new BooleanIntProcedure(){

                public void value(boolean each, int occurrences) {
                    if (each) {
                        BooleanHashBag.this.trueCount = 0;
                    } else {
                        BooleanHashBag.this.falseCount = 0;
                    }
                }
            });
        } else {
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                boolean each = iterator.next();
                if (each) {
                    this.trueCount = 0;
                    continue;
                }
                this.falseCount = 0;
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(BooleanIterable elements) {
        BooleanSet set;
        int oldSize = this.size();
        BooleanSet booleanSet = set = elements instanceof BooleanSet ? (BooleanSet)elements : elements.toSet();
        if (!set.contains(true) && this.containsTrue()) {
            this.trueCount = 0;
        }
        if (!set.contains(false) && this.containsFalse()) {
            this.falseCount = 0;
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(boolean ... source) {
        return this.retainAll(BooleanHashSet.newSetWith(source));
    }

    @Override
    public void addOccurrences(boolean item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            if (item) {
                this.trueCount += occurrences;
            } else {
                this.falseCount += occurrences;
            }
        }
    }

    @Override
    public boolean removeOccurrences(boolean item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        if (item) {
            if (!this.containsTrue()) {
                return false;
            }
            this.trueCount -= occurrences;
            if (this.trueCount < 0) {
                this.trueCount = 0;
            }
        } else {
            if (!this.containsFalse()) {
                return false;
            }
            this.falseCount -= occurrences;
            if (this.falseCount < 0) {
                this.falseCount = 0;
            }
        }
        return true;
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        int i;
        for (i = 0; i < this.falseCount; ++i) {
            procedure.value(false);
        }
        for (i = 0; i < this.trueCount; ++i) {
            procedure.value(true);
        }
    }

    @Override
    public MutableBooleanBag select(final BooleanPredicate predicate) {
        final BooleanHashBag result = new BooleanHashBag();
        this.forEachWithOccurrences(new BooleanIntProcedure(){

            public void value(boolean each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public MutableBooleanBag reject(final BooleanPredicate predicate) {
        final BooleanHashBag result = new BooleanHashBag();
        this.forEachWithOccurrences(new BooleanIntProcedure(){

            public void value(boolean each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        MutableBooleanIterator it = this.booleanIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    @Override
    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof BooleanBag)) {
            return false;
        }
        BooleanBag bag = (BooleanBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.falseCount == bag.occurrencesOf(false) && this.trueCount == bag.occurrencesOf(true);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsFalse()) {
            result = 0x4D5 ^ this.falseCount;
        }
        if (this.containsTrue()) {
            result += 0x4CF ^ this.trueCount;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            int i;
            appendable.append(start);
            boolean firstItem = true;
            for (i = 0; i < this.falseCount; ++i) {
                if (!firstItem) {
                    appendable.append(separator);
                }
                appendable.append("false");
                firstItem = false;
            }
            for (i = 0; i < this.trueCount; ++i) {
                if (!firstItem) {
                    appendable.append(separator);
                }
                appendable.append("true");
                firstItem = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count(BooleanPredicate predicate) {
        int result = 0;
        if (this.containsFalse() && predicate.accept(false)) {
            result = this.falseCount;
        }
        if (this.containsTrue() && predicate.accept(true)) {
            result += this.trueCount;
        }
        return result;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.containsFalse() && predicate.accept(false) || this.containsTrue() && predicate.accept(true);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return !(this.containsFalse() && !predicate.accept(false) || this.containsTrue() && !predicate.accept(true));
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !(this.containsFalse() && predicate.accept(false) || this.containsTrue() && predicate.accept(true));
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        if (this.containsFalse() && predicate.accept(false)) {
            return false;
        }
        if (this.containsTrue() && predicate.accept(true)) {
            return true;
        }
        return ifNone;
    }

    @Override
    public <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        HashBag result = HashBag.newBag();
        if (this.containsFalse()) {
            result.addOccurrences(function.valueOf(false), this.falseCount);
        }
        if (this.containsTrue()) {
            result.addOccurrences(function.valueOf(true), this.trueCount);
        }
        return result;
    }

    @Override
    public boolean[] toArray() {
        final boolean[] array = new boolean[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new BooleanIntProcedure(){

            public void value(boolean each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    @Override
    public MutableBooleanIterator booleanIterator() {
        return new InternalIterator(this.falseCount, this.trueCount);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.falseCount);
        out.writeInt(this.trueCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.falseCount = in.readInt();
        this.trueCount = in.readInt();
    }

    private final class InternalIterator
    implements MutableBooleanIterator {
        private int internalFalseCount;
        private int internalTrueCount;
        private boolean lastBooleanValue;
        private boolean removedAlready = true;

        private InternalIterator(int falseCount, int trueCount) {
            this.internalFalseCount = falseCount;
            this.internalTrueCount = trueCount;
        }

        public boolean hasNext() {
            return this.internalFalseCount > 0 || this.internalTrueCount > 0;
        }

        public boolean next() {
            this.removedAlready = false;
            if (this.internalFalseCount > 0) {
                --this.internalFalseCount;
                this.lastBooleanValue = false;
                return false;
            }
            if (this.internalTrueCount > 0) {
                --this.internalTrueCount;
                this.lastBooleanValue = true;
                return true;
            }
            throw new NoSuchElementException("next() called, but the iterator is exhausted");
        }

        public void remove() {
            if (this.removedAlready) {
                throw new IllegalStateException();
            }
            if (this.lastBooleanValue) {
                BooleanHashBag.this.trueCount--;
            } else {
                BooleanHashBag.this.falseCount--;
            }
            this.removedAlready = true;
        }
    }
}

