/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.MutableObjectIntMap;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.AbstractMutableBag;
import com.gs.collections.impl.block.factory.primitive.IntToIntFunctions;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBag<T>
extends AbstractMutableBag<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private MutableObjectIntMap<T> items;
    private int size;

    public HashBag() {
        this.items = ObjectIntHashMap.newMap();
    }

    public HashBag(int size) {
        this.items = new ObjectIntHashMap<T>(size);
    }

    private HashBag(MutableObjectIntMap<T> map) {
        this.items = map;
        this.size = (int)map.sum();
    }

    public static <E> HashBag<E> newBag() {
        return new HashBag();
    }

    public static <E> HashBag<E> newBag(int size) {
        return new HashBag(size);
    }

    public static <E> HashBag<E> newBag(Bag<? extends E> source) {
        HashBag<E> result = HashBag.newBag(source.sizeDistinct());
        super.addAllBag(source);
        return result;
    }

    public static <E> HashBag<E> newBag(Iterable<? extends E> source) {
        if (source instanceof Bag) {
            return HashBag.newBag((Bag)source);
        }
        return HashBag.newBagWith(Iterate.toArray(source));
    }

    public static <E> HashBag<E> newBagWith(E ... elements) {
        HashBag<E> result = HashBag.newBag();
        ArrayIterate.addAllTo(elements, result);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> source) {
        if (source instanceof Bag) {
            return this.addAllBag((Bag)((Object)source));
        }
        return super.addAll(source);
    }

    private boolean addAllBag(Bag<? extends T> source) {
        source.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each, int occurrences) {
                HashBag.this.addOccurrences(each, occurrences);
            }
        });
        return source.notEmpty();
    }

    @Override
    public void addOccurrences(T item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, IntToIntFunctions.add(occurrences));
            this.size += occurrences;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bag)) {
            return false;
        }
        final Bag bag = (Bag)other;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keyValuesView().allSatisfy(new Predicate<ObjectIntPair<T>>(){

            @Override
            public boolean accept(ObjectIntPair<T> each) {
                return bag.occurrencesOf(each.getOne()) == each.getTwo();
            }
        });
    }

    @Override
    public int hashCode() {
        final Counter counter = new Counter();
        this.items.forEachKeyValue(new ObjectIntProcedure<T>(){

            @Override
            public void value(T item, int count) {
                counter.add((item == null ? 0 : item.hashCode()) ^ count);
            }
        });
        return counter.getCount();
    }

    @Override
    protected RichIterable<T> getKeysView() {
        return this.items.keysView();
    }

    @Override
    public int sizeDistinct() {
        return this.items.size();
    }

    @Override
    public int occurrencesOf(Object item) {
        return this.items.get(item);
    }

    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.items.forEachKeyValue(objectIntProcedure);
    }

    @Override
    public MutableBag<T> selectByOccurrences(final IntPredicate predicate) {
        MutableObjectIntMap<T> map = this.items.select(new ObjectIntPredicate<T>(){

            @Override
            public boolean accept(T each, int occurrences) {
                return predicate.accept(occurrences);
            }
        });
        return new HashBag<T>(map);
    }

    @Override
    public MutableMap<T, Integer> toMapOfItemToCount() {
        final UnifiedMap map = UnifiedMap.newMap(this.items.size());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            @Override
            public void value(T item, int count) {
                map.put(item, count);
            }
        });
        return map;
    }

    @Override
    public boolean remove(Object item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == -1) {
                return false;
            }
        }
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ((ObjectIntHashMap)this.items).writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.items = new ObjectIntHashMap<T>();
        ((ObjectIntHashMap)this.items).readExternal(in);
        this.size = (int)this.items.sum();
    }

    @Override
    public void each(final Procedure<? super T> procedure) {
        this.items.forEachKeyValue(new ObjectIntProcedure<T>(){

            @Override
            public void value(T key, int count) {
                for (int i = 0; i < count; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    @Override
    public void forEachWithIndex(final ObjectIntProcedure<? super T> objectIntProcedure) {
        final Counter index = new Counter();
        this.items.forEachKeyValue(new ObjectIntProcedure<T>(){

            @Override
            public void value(T key, int count) {
                for (int i = 0; i < count; ++i) {
                    objectIntProcedure.value(key, index.getCount());
                    index.increment();
                }
            }
        });
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super T, ? super P> procedure, final P parameter) {
        this.items.forEachKeyValue(new ObjectIntProcedure<T>(){

            @Override
            public void value(T key, int count) {
                for (int i = 0; i < count; ++i) {
                    procedure.value(key, parameter);
                }
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    @Override
    public boolean removeOccurrences(Object item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.subtract(occurrences));
        if (newValue <= 0) {
            this.size -= occurrences + newValue;
            this.items.remove(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    @Override
    public boolean setOccurrences(T item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot set a negative number of occurrences");
        }
        int originalOccurrences = this.items.get(item);
        if (originalOccurrences == occurrences) {
            return false;
        }
        if (occurrences == 0) {
            this.items.remove(item);
        } else {
            this.items.put(item, occurrences);
        }
        this.size -= originalOccurrences - occurrences;
        return true;
    }

    @Override
    public HashBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableBag<T> newEmpty() {
        return HashBag.newBag();
    }

    @Override
    public HashBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public HashBag<T> withAll(Iterable<? extends T> iterable) {
        this.addAllIterable(iterable);
        return this;
    }

    @Override
    public HashBag<T> withoutAll(Iterable<? extends T> iterable) {
        this.removeAllIterable(iterable);
        return this;
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        boolean changed = false;
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!predicate.accept(key)) continue;
            this.size -= this.items.get(key);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        boolean changed = false;
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!predicate.accept(key, parameter)) continue;
            this.size -= this.items.get(key);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        int oldSize = this.size;
        if (iterable instanceof Bag) {
            Bag source = (Bag)iterable;
            source.forEachWithOccurrences(new ObjectIntProcedure<Object>(){

                @Override
                public void value(Object each, int parameter) {
                    int removed = HashBag.this.items.removeKeyIfAbsent(each, 0);
                    HashBag hashBag = HashBag.this;
                    hashBag.size = hashBag.size - removed;
                }
            });
        } else {
            for (Object each : iterable) {
                int removed = this.items.removeKeyIfAbsent(each, 0);
                this.size -= removed;
            }
        }
        return this.size != oldSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.items.containsKey(o);
    }

    @Override
    public <V> HashBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap());
    }

    @Override
    public <V> HashBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap());
    }

    @Override
    public HashBag<T> with(T ... elements) {
        this.addAll((Collection<? extends T>)Arrays.asList(elements));
        return this;
    }

    public HashBag<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    @Override
    public boolean add(T item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public HashBag<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.iterator = HashBag.this.items.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrences > 0 || this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.occurrences == 0) {
                this.currentItem = this.iterator.next();
                this.occurrences = HashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.iterator.remove();
                HashBag.this.size--;
            } else {
                HashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

