/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.bag.primitive.ShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortIntProcedure;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortHashBag
implements ImmutableShortBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortBag delegate;

    private ImmutableShortHashBag(short[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = ShortHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use ShortBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableShortHashBag newBagWith(short ... elements) {
        return new ImmutableShortHashBag(elements);
    }

    @Override
    public ImmutableShortBag newWith(short element) {
        return ShortHashBag.newBag(this.delegate).with(element).toImmutable();
    }

    @Override
    public ImmutableShortBag newWithout(short element) {
        ShortHashBag hashBag = ShortHashBag.newBag(this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    @Override
    public ImmutableShortBag newWithAll(ShortIterable elements) {
        ShortHashBag bag = ShortHashBag.newBag(this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    @Override
    public ImmutableShortBag newWithoutAll(ShortIterable elements) {
        ShortHashBag bag = ShortHashBag.newBag(this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(short ... elements) {
        return this.delegate.containsAll(elements);
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public ImmutableShortBag select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public MutableShortList toList() {
        return this.delegate.toList();
    }

    @Override
    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    @Override
    public int occurrencesOf(short item) {
        return this.delegate.occurrencesOf(item);
    }

    @Override
    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
        this.delegate.forEachWithOccurrences(shortIntProcedure);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public short min() {
        return this.delegate.min();
    }

    @Override
    public short max() {
        return this.delegate.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public ImmutableShortBag toImmutable() {
        return this;
    }

    @Override
    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public short[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.delegate.shortIterator());
    }

    private Object writeReplace() {
        return new ImmutableShortBagSerializationProxy(this);
    }

    protected static class ImmutableShortBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortBag bag;

        public ImmutableShortBagSerializationProxy() {
        }

        protected ImmutableShortBagSerializationProxy(ShortBag bag) {
            this.bag = bag;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences(new CheckedShortIntProcedure(){

                    public void safeValue(short item, int count) throws IOException {
                        out.writeShort(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortHashBag deserializedBag = new ShortHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readShort(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

