/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.FloatBag;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.primitive.FloatBags;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonBag
implements ImmutableFloatBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element1;

    ImmutableFloatSingletonBag(float element) {
        this.element1 = element;
    }

    @Override
    public ImmutableFloatBag newWith(float element) {
        return FloatBags.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableFloatBag newWithout(float element) {
        return Float.compare(this.element1, element) == 0 ? FloatBags.immutable.with() : this;
    }

    @Override
    public ImmutableFloatBag newWithAll(FloatIterable elements) {
        return FloatHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    @Override
    public ImmutableFloatBag newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element1) ? FloatBags.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(float value) {
        return Float.compare(this.element1, value) == 0;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public ImmutableFloatBag select(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatHashBag.newBagWith(this.element1).toImmutable() : new FloatHashBag().toImmutable();
    }

    @Override
    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? new FloatHashBag().toImmutable() : FloatHashBag.newBagWith(this.element1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element1);
    }

    @Override
    public int sizeDistinct() {
        return 1;
    }

    @Override
    public int occurrencesOf(float item) {
        return Float.compare(this.element1, item) == 0 ? 1 : 0;
    }

    @Override
    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
        floatIntProcedure.value(this.element1, 1);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public double sum() {
        return this.element1;
    }

    @Override
    public float min() {
        return this.element1;
    }

    @Override
    public float max() {
        return this.element1;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.element1;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public float[] toSortedArray() {
        return new float[]{this.element1};
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element1);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatBag)) {
            return false;
        }
        FloatBag bag = (FloatBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.element1) ^ 1;
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element1);
    }

    @Override
    public ImmutableFloatBag toImmutable() {
        return this;
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.element1};
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(FloatHashBag.newBagWith(this.element1).floatIterator());
    }
}

