/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.CharBag;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.primitive.CharBags;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharSingletonBag
implements ImmutableCharBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char element1;

    ImmutableCharSingletonBag(char element) {
        this.element1 = element;
    }

    @Override
    public ImmutableCharBag newWith(char element) {
        return CharBags.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableCharBag newWithout(char element) {
        return this.element1 == element ? CharBags.immutable.with() : this;
    }

    @Override
    public ImmutableCharBag newWithAll(CharIterable elements) {
        return CharHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    @Override
    public ImmutableCharBag newWithoutAll(CharIterable elements) {
        return elements.contains(this.element1) ? CharBags.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(char value) {
        return this.element1 == value;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public ImmutableCharBag select(CharPredicate predicate) {
        return predicate.accept(this.element1) ? CharHashBag.newBagWith(this.element1).toImmutable() : new CharHashBag().toImmutable();
    }

    @Override
    public ImmutableCharBag reject(CharPredicate predicate) {
        return predicate.accept(this.element1) ? new CharHashBag().toImmutable() : CharHashBag.newBagWith(this.element1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newListWith(this.element1);
    }

    @Override
    public int sizeDistinct() {
        return 1;
    }

    @Override
    public int occurrencesOf(char item) {
        return this.element1 == item ? 1 : 0;
    }

    @Override
    public void forEachWithOccurrences(CharIntProcedure charIntProcedure) {
        charIntProcedure.value(this.element1, 1);
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public int count(CharPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public long sum() {
        return this.element1;
    }

    @Override
    public char min() {
        return this.element1;
    }

    @Override
    public char max() {
        return this.element1;
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.element1;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public char[] toSortedArray() {
        return new char[]{this.element1};
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.element1);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharBag)) {
            return false;
        }
        CharBag bag = (CharBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode() {
        return this.element1 ^ '\u0001';
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.element1);
    }

    @Override
    public ImmutableCharBag toImmutable() {
        return this;
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public char[] toArray() {
        return new char[]{this.element1};
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(CharHashBag.newBagWith(this.element1).charIterator());
    }
}

