/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ByteBag;
import com.gs.collections.api.bag.primitive.ImmutableByteBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.primitive.ByteBags;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableByteSingletonBag
implements ImmutableByteBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte element1;

    ImmutableByteSingletonBag(byte element) {
        this.element1 = element;
    }

    @Override
    public ImmutableByteBag newWith(byte element) {
        return ByteBags.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableByteBag newWithout(byte element) {
        return this.element1 == element ? ByteBags.immutable.with() : this;
    }

    @Override
    public ImmutableByteBag newWithAll(ByteIterable elements) {
        return ByteHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    @Override
    public ImmutableByteBag newWithoutAll(ByteIterable elements) {
        return elements.contains(this.element1) ? ByteBags.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(byte value) {
        return this.element1 == value;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public ImmutableByteBag select(BytePredicate predicate) {
        return predicate.accept(this.element1) ? ByteHashBag.newBagWith(this.element1).toImmutable() : new ByteHashBag().toImmutable();
    }

    @Override
    public ImmutableByteBag reject(BytePredicate predicate) {
        return predicate.accept(this.element1) ? new ByteHashBag().toImmutable() : ByteHashBag.newBagWith(this.element1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.element1);
    }

    @Override
    public int sizeDistinct() {
        return 1;
    }

    @Override
    public int occurrencesOf(byte item) {
        return this.element1 == item ? 1 : 0;
    }

    @Override
    public void forEachWithOccurrences(ByteIntProcedure byteIntProcedure) {
        byteIntProcedure.value(this.element1, 1);
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public long sum() {
        return this.element1;
    }

    @Override
    public byte min() {
        return this.element1;
    }

    @Override
    public byte max() {
        return this.element1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.element1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.element1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.element1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteBag)) {
            return false;
        }
        ByteBag bag = (ByteBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode() {
        return this.element1 ^ 1;
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.element1);
    }

    @Override
    public ImmutableByteBag toImmutable() {
        return this;
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.element1};
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(ByteHashBag.newBagWith(this.element1).byteIterator());
    }
}

