/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.AnyOfSelection;

public class Target
extends AbstractTarget {
    List<AnyOfSelection> anyOfSelections;

    public Target() {
        this.anyOfSelections = new ArrayList<AnyOfSelection>();
    }

    public Target(List<AnyOfSelection> anyOfSelections) {
        this.anyOfSelections = anyOfSelections;
    }

    public static Target getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        ArrayList<AnyOfSelection> anyOfSelections = new ArrayList<AnyOfSelection>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AnyOf".equals(DOMHelper.getLocalName(child))) continue;
            anyOfSelections.add(AnyOfSelection.getInstance(child, metaData));
        }
        return new Target(anyOfSelections);
    }

    @Override
    public MatchResult match(EvaluationCtx context) {
        Status firstIndeterminateStatus = null;
        for (AnyOfSelection anyOfSelection : this.anyOfSelections) {
            MatchResult result = anyOfSelection.match(context);
            if (result.getResult() == 1) {
                return result;
            }
            if (result.getResult() != 2 || firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (firstIndeterminateStatus == null) {
            return new MatchResult(0);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public List<AnyOfSelection> getAnyOfSelections() {
        return this.anyOfSelections;
    }

    @Override
    public String encode() {
        StringBuilder sb = new StringBuilder();
        this.encode(sb);
        return sb.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Target>\n");
        if (this.anyOfSelections != null) {
            for (AnyOfSelection anyOfSelection : this.anyOfSelections) {
                anyOfSelection.encode(builder);
            }
        }
        builder.append("</Target>\n");
    }
}

