/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.utils.Utils;

public class Attributes {
    private URI category;
    private Node content;
    private Set<Attribute> attributes;
    private String id;

    public Attributes(URI category, Set<Attribute> attributes) {
        this(category, null, attributes, null);
    }

    public Attributes(URI category, Node content, Set<Attribute> attributes, String id) {
        this.category = category;
        this.content = content;
        this.attributes = attributes;
        this.id = id;
    }

    public static Attributes getInstance(Node root) throws ParsingException {
        URI category;
        Node content = null;
        String id = null;
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (!DOMHelper.getLocalName(root).equals("Attributes")) {
            throw new ParsingException("Attributes object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            category = new URI(attrs.getNamedItem("Category").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributesType", e);
        }
        try {
            Node idNode = attrs.getNamedItem("id");
            if (idNode != null) {
                id = idNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributesType", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (DOMHelper.getLocalName(node).equals("Content")) {
                if (content != null) {
                    throw new ParsingException("Too many content elements are defined.");
                }
                content = node.getFirstChild();
                continue;
            }
            if (!DOMHelper.getLocalName(node).equals("Attribute")) continue;
            attributes.add(Attribute.getInstance(node, 3));
        }
        if (content != null) {
            try {
                DocumentBuilderFactory dbf = Utils.getSecuredDocumentBuilderFactory();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                dbf.setNamespaceAware(true);
                Document docRoot = builder.newDocument();
                Node topRoot = docRoot.importNode(content, true);
                docRoot.appendChild(topRoot);
                content = docRoot.getDocumentElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Attributes(category, content, attributes, id);
    }

    public URI getCategory() {
        return this.category;
    }

    public Node getContent() {
        return this.content;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        builder.append("<Attributes Category=\"").append(this.category.toString()).append("\">");
        for (Attribute attribute : this.attributes) {
            attribute.encode(builder);
        }
        if (this.content != null) {
            // empty if block
        }
        builder.append("</Attributes>");
    }
}

