/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AttributeAssignment;

public class Advice {
    private URI adviceId;
    private List<AttributeAssignment> assignments;

    public Advice(URI adviceId, List<AttributeAssignment> assignments) {
        this.adviceId = adviceId;
        this.assignments = assignments;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public static Advice getInstance(Node root) throws ParsingException {
        URI adviceId;
        ArrayList<AttributeAssignment> assignments = new ArrayList<AttributeAssignment>();
        if (!DOMHelper.getLocalName(root).equals("Advice")) {
            throw new ParsingException("Advice object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            adviceId = new URI(nodeAttributes.getNamedItem("AdviceId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AdviceId in AdviceType", e);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AttributeAssignment".equals(DOMHelper.getLocalName(child))) continue;
            assignments.add(AttributeAssignment.getInstance(child));
        }
        return new Advice(adviceId, assignments);
    }

    public URI getAdviceId() {
        return this.adviceId;
    }

    public List<AttributeAssignment> getAssignments() {
        return this.assignments;
    }

    public void encode(StringBuilder builder) {
        builder.append("<Advice AdviceId=\"").append(this.adviceId).append("\" >");
        if (this.assignments != null && this.assignments.size() > 0) {
            for (AttributeAssignment assignment : this.assignments) {
                assignment.encode(builder);
            }
        }
        builder.append("</Advice>");
    }
}

