/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.TargetMatch;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml2.TargetMatchGroup;

public class TargetSection {
    private List<TargetMatchGroup> matchGroups;
    private int matchType;
    private int xacmlVersion;

    public TargetSection(List<TargetMatchGroup> matchGroups, int matchType, int xacmlVersion) {
        this.matchGroups = matchGroups == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList<TargetMatchGroup>(matchGroups));
        this.matchType = matchType;
        this.xacmlVersion = xacmlVersion;
    }

    public static TargetSection getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatchGroup> groups = new ArrayList<TargetMatchGroup>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String typeName;
            Node child = children.item(i);
            String name = DOMHelper.getLocalName(child);
            if (name.equals(typeName = TargetMatch.NAMES[matchType])) {
                groups.add(TargetMatchGroup.getInstance(child, matchType, metaData));
                continue;
            }
            if (name.equals("Any" + typeName)) break;
        }
        return new TargetSection(groups, matchType, metaData.getXACMLVersion());
    }

    public List getMatchGroups() {
        return this.matchGroups;
    }

    public boolean matchesAny() {
        return this.matchGroups.isEmpty();
    }

    public MatchResult match(EvaluationCtx context) {
        if (this.matchGroups.isEmpty()) {
            return new MatchResult(0);
        }
        Status firstIndeterminateStatus = null;
        for (TargetMatchGroup group : this.matchGroups) {
            MatchResult result = group.match(context);
            if (result.getResult() == 0) {
                return result;
            }
            if (result.getResult() != 2 || firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (firstIndeterminateStatus == null) {
            return new MatchResult(1);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        String name = TargetMatch.NAMES[this.matchType];
        if (this.matchGroups.isEmpty()) {
            if (this.xacmlVersion == 0) {
                builder.append("<").append(name).append("s>\n");
                builder.append("<Any").append(name).append("/>\n");
                builder.append("</").append(name).append("s>\n");
            }
        } else {
            builder.append("<").append(name).append("s>\n");
            for (TargetMatchGroup group : this.matchGroups) {
                group.encode(builder);
            }
            builder.append("</").append(name).append("s>\n");
        }
    }
}

