/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.TargetMatch;
import org.wso2.balana.ctx.EvaluationCtx;

public class TargetMatchGroup {
    private List<TargetMatch> matches;
    private int matchType;
    private static final Log logger = LogFactory.getLog(TargetMatchGroup.class);

    public TargetMatchGroup(List<TargetMatch> matchElements, int matchType) {
        this.matches = matchElements == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList<TargetMatch>(matchElements));
        this.matchType = matchType;
    }

    public static TargetMatchGroup getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatch> matches = new ArrayList<TargetMatch>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String matchName;
            Node child = children.item(i);
            String name = DOMHelper.getLocalName(child);
            if (!name.equals(matchName = TargetMatch.NAMES[matchType] + "Match")) continue;
            matches.add(TargetMatch.getInstance(child, matchType, metaData));
        }
        return new TargetMatchGroup(matches, matchType);
    }

    public MatchResult match(EvaluationCtx context) {
        TargetMatch targetMatch;
        MatchResult result = null;
        if (this.matches.isEmpty()) {
            return new MatchResult(0);
        }
        Iterator<TargetMatch> iterator = this.matches.iterator();
        while (iterator.hasNext() && (result = (targetMatch = iterator.next()).match(context)).getResult() == 0) {
        }
        return result;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        String name = TargetMatch.NAMES[this.matchType];
        builder.append("<").append(name).append(">\n");
        for (TargetMatch targetMatch : this.matches) {
            targetMatch.encode(builder);
        }
        builder.append("</").append(name).append(">\n");
    }
}

