/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.xacml2.Result;

public class Obligation
extends AbstractObligation
implements ObligationResult {
    private List<Attribute> assignments;

    public Obligation(URI obligationId, int fulfillOn, List<Attribute> assignments) {
        this.obligationId = obligationId;
        this.fulfillOn = fulfillOn;
        this.assignments = Collections.unmodifiableList(new ArrayList<Attribute>(assignments));
    }

    public static Obligation getInstance(Node root) throws ParsingException {
        int fulfillOn;
        String effect;
        URI id;
        ArrayList<Attribute> assignments = new ArrayList<Attribute>();
        AttributeFactory attrFactory = Balana.getInstance().getAttributeFactory();
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute ObligationId", e);
        }
        try {
            effect = attrs.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute FulfillOn", e);
        }
        if (effect.equals("Permit")) {
            fulfillOn = 0;
        } else if (effect.equals("Deny")) {
            fulfillOn = 1;
        } else {
            throw new ParsingException("Invalid Effect type: " + effect);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("AttributeAssignment")) continue;
            try {
                URI attrId = new URI(node.getAttributes().getNamedItem("AttributeId").getNodeValue());
                AttributeValue attrValue = attrFactory.createValue(node);
                assignments.add(new Attribute(attrId, null, null, attrValue, 2));
                continue;
            }
            catch (URISyntaxException use) {
                throw new ParsingException("Error parsing URI", use);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException(uie.getMessage(), uie);
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing attribute assignments", e);
            }
        }
        return new Obligation(id, fulfillOn, assignments);
    }

    @Override
    public ObligationResult evaluate(EvaluationCtx ctx) {
        return new Obligation(this.obligationId, this.fulfillOn, this.assignments);
    }

    public List<Attribute> getAssignments() {
        return this.assignments;
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Obligation ObligationId=\"").append(this.obligationId.toString()).append("\" FulfillOn=\"").append(Result.DECISIONS[this.fulfillOn]).append("\">\n");
        for (Attribute assignment : this.assignments) {
            builder.append("<AttributeAssignment AttributeId=\"").append(assignment.getId().toString()).append("\" DataType=\"").append(assignment.getType().toString()).append("\">").append(assignment.getValue().encode()).append("</AttributeAssignment>\n");
        }
        builder.append("</Obligation>");
    }
}

