/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.finder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicySet;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.xacml2.DenyOverridesPolicyAlg;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.PolicyFinderModule;
import org.wso2.balana.finder.PolicyFinderResult;
import org.wso2.balana.utils.Utils;

public class FileBasedPolicyFinderModule
extends PolicyFinderModule {
    private PolicyFinder finder = null;
    private Map<URI, AbstractPolicy> policies = new HashMap<URI, AbstractPolicy>();
    private Set<String> policyLocations;
    private PolicyCombiningAlgorithm combiningAlg;
    private static final Log log = LogFactory.getLog(FileBasedPolicyFinderModule.class);
    public static final String POLICY_DIR_PROPERTY = "org.wso2.balana.PolicyDirectory";

    public FileBasedPolicyFinderModule() {
        if (System.getProperty(POLICY_DIR_PROPERTY) != null) {
            this.policyLocations = new HashSet<String>();
            this.policyLocations.add(System.getProperty(POLICY_DIR_PROPERTY));
        }
    }

    public FileBasedPolicyFinderModule(Set<String> policyLocations) {
        this.policyLocations = policyLocations;
    }

    @Override
    public void init(PolicyFinder finder) {
        this.finder = finder;
        this.loadPolicies();
        this.combiningAlg = new DenyOverridesPolicyAlg();
    }

    @Override
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        ArrayList<AbstractPolicy> selectedPolicies = new ArrayList<AbstractPolicy>();
        Set<Map.Entry<URI, AbstractPolicy>> entrySet = this.policies.entrySet();
        for (Map.Entry<URI, AbstractPolicy> entry : entrySet) {
            AbstractPolicy policy = entry.getValue();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new PolicyFinderResult(match.getStatus());
            }
            if (result != 0) continue;
            if (this.combiningAlg == null && selectedPolicies.size() > 0) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicies.add(policy);
        }
        switch (selectedPolicies.size()) {
            case 0: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No matching XACML policy found");
                }
                return new PolicyFinderResult();
            }
            case 1: {
                return new PolicyFinderResult((AbstractPolicy)selectedPolicies.get(0));
            }
        }
        return new PolicyFinderResult(new PolicySet(null, this.combiningAlg, null, selectedPolicies));
    }

    @Override
    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy = this.policies.get(idReference);
        if (policy != null && (type == 0 ? policy instanceof Policy : policy instanceof PolicySet)) {
            return new PolicyFinderResult(policy);
        }
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        Status status = new Status(code, "couldn't load referenced policy");
        return new PolicyFinderResult(status);
    }

    @Override
    public boolean isIdReferenceSupported() {
        return true;
    }

    @Override
    public boolean isRequestSupported() {
        return true;
    }

    protected void loadPolicies() {
        this.policies.clear();
        for (String policyLocation : this.policyLocations) {
            File file = new File(policyLocation);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                String[] files = file.list();
                if (files == null) continue;
                for (String policyFileLocation : files) {
                    File policyFile = new File(policyLocation + File.separator + policyFileLocation);
                    if (policyFile.isDirectory() || policyFile.isHidden()) continue;
                    this.loadPolicy(policyLocation + File.separator + policyFileLocation, this.finder);
                }
                continue;
            }
            this.loadPolicy(policyLocation, this.finder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element loadPolicy(String policyFile, PolicyFinder finder) {
        Element root = null;
        AbstractPolicy policy = null;
        InputStream stream = null;
        try {
            DocumentBuilderFactory factory = Utils.getSecuredDocumentBuilderFactory();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            stream = new FileInputStream(policyFile);
            Document doc = db.parse(stream);
            root = doc.getDocumentElement();
            String name = DOMHelper.getLocalName(root);
            if (name.equals("Policy")) {
                policy = Policy.getInstance(root);
            } else if (name.equals("PolicySet")) {
                policy = PolicySet.getInstance(root, finder);
            }
        }
        catch (Exception e) {
            log.error((Object)("Fail to load policy : " + policyFile), (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream");
                }
            }
        }
        if (policy != null) {
            this.policies.put(policy.getId(), policy);
        }
        return root;
    }
}

