/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.finder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.AttributeFinderModule;

public class AttributeFinder {
    private List<AttributeFinderModule> allModules = new ArrayList<AttributeFinderModule>();
    private List<AttributeFinderModule> designatorModules = new ArrayList<AttributeFinderModule>();
    private List<AttributeFinderModule> selectorModules = new ArrayList<AttributeFinderModule>();
    private static final Log logger = LogFactory.getLog(AttributeFinder.class);

    public List<AttributeFinderModule> getModules() {
        return new ArrayList<AttributeFinderModule>(this.allModules);
    }

    public void setModules(List<AttributeFinderModule> modules) {
        Iterator<AttributeFinderModule> it = modules.iterator();
        this.allModules = new ArrayList<AttributeFinderModule>(modules);
        this.designatorModules = new ArrayList<AttributeFinderModule>();
        this.selectorModules = new ArrayList<AttributeFinderModule>();
        while (it.hasNext()) {
            AttributeFinderModule module = it.next();
            if (module.isDesignatorSupported()) {
                this.designatorModules.add(module);
            }
            if (!module.isSelectorSupported()) continue;
            this.selectorModules.add(module);
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, String issuer, URI category, EvaluationCtx context) {
        Iterator<AttributeFinderModule> it = this.designatorModules.iterator();
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        while (it.hasNext()) {
            AttributeFinderModule module = it.next();
            if (module.getSupportedIds() != null && module.getSupportedCategories() != null && (!module.getSupportedCategories().contains(category.toString()) || !module.getSupportedIds().contains(attributeId.toString()))) continue;
            EvaluationResult result = module.findAttribute(attributeType, attributeId, issuer, category, context);
            if (result.indeterminate()) {
                logger.error((Object)("Error while trying to resolve values: " + result.getStatus().getMessage()));
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            Iterator iterator = bag.iterator();
            while (iterator.hasNext()) {
                AttributeValue attr = (AttributeValue)iterator.next();
                attributeValues.add(attr);
            }
        }
        if (attributeValues.isEmpty() && logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to resolve any values for " + attributeId.toString()));
        }
        return new EvaluationResult(new BagAttribute(attributeType, attributeValues));
    }

    public EvaluationResult findAttribute(String contextPath, URI attributeType, EvaluationCtx context, String xpathVersion) {
        Iterator<AttributeFinderModule> it = this.selectorModules.iterator();
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        while (it.hasNext()) {
            AttributeFinderModule module = it.next();
            EvaluationResult result = module.findAttribute(contextPath, attributeType, null, null, context, xpathVersion);
            if (result.indeterminate()) {
                logger.error((Object)("Error while trying to resolve values: " + result.getStatus().getMessage()));
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            Iterator iterator = bag.iterator();
            while (iterator.hasNext()) {
                AttributeValue attr = (AttributeValue)iterator.next();
                attributeValues.add(attr);
            }
        }
        if (attributeValues.isEmpty() && logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to resolve any values for " + contextPath));
        }
        return new EvaluationResult(new BagAttribute(attributeType, attributeValues));
    }

    public EvaluationResult findAttribute(String contextPath, String contextSelector, URI attributeType, Node root, EvaluationCtx context, String xpathVersion) {
        Iterator<AttributeFinderModule> it = this.selectorModules.iterator();
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        while (it.hasNext()) {
            AttributeFinderModule module = it.next();
            EvaluationResult result = module.findAttribute(contextPath, attributeType, contextSelector, root, context, xpathVersion);
            if (result.indeterminate()) {
                logger.error((Object)("Error while trying to resolve values: " + result.getStatus().getMessage()));
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            Iterator iterator = bag.iterator();
            while (iterator.hasNext()) {
                AttributeValue attr = (AttributeValue)iterator.next();
                attributeValues.add(attr);
            }
        }
        if (attributeValues.isEmpty() && logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to resolve any values for " + contextPath));
        }
        return new EvaluationResult(new BagAttribute(attributeType, attributeValues));
    }
}

