/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.DefaultNamespaceContext;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.attr.xacml3.XPathAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.BasicEvaluationCtx;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.xacml3.RequestCtx;
import org.wso2.balana.finder.ResourceFinderResult;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.balana.xacml3.AttributesReference;
import org.wso2.balana.xacml3.MultiRequests;
import org.wso2.balana.xacml3.MultipleCtxResult;
import org.wso2.balana.xacml3.RequestReference;

public class XACML3EvaluationCtx
extends BasicEvaluationCtx {
    private Set<Attributes> attributesSet;
    private Set<Attributes> multipleContentSelectors;
    private boolean multipleAttributes;
    private Set<PolicyReference> policyReferences;
    private Map<String, List<Attributes>> mapAttributes;
    private RequestCtx requestCtx;
    private Attribute resourceScopeAttribute;
    private int resourceScope;
    private Attribute resourceId;
    private static final Log logger = LogFactory.getLog(XACML3EvaluationCtx.class);

    public XACML3EvaluationCtx(RequestCtx requestCtx, PDPConfig pdpConfig) {
        this.currentDate = null;
        this.currentTime = null;
        this.currentDateTime = null;
        this.mapAttributes = new HashMap<String, List<Attributes>>();
        this.attributesSet = requestCtx.getAttributesSet();
        this.pdpConfig = pdpConfig;
        this.requestCtx = requestCtx;
        this.setupAttributes(this.attributesSet, this.mapAttributes);
    }

    @Override
    public EvaluationResult getAttribute(URI type, URI id, String issuer, URI category) {
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        List<Attributes> attributesSet = this.mapAttributes.get(category.toString());
        if (attributesSet != null && attributesSet.size() > 0) {
            Set<Attribute> attributeSet = attributesSet.get(0).getAttributes();
            for (Attribute attribute : attributeSet) {
                if (!attribute.getId().toString().equals(id.toString()) || !attribute.getType().toString().equals(type.toString()) || issuer != null && !issuer.equals(attribute.getIssuer()) || attribute.getValue() == null) continue;
                List<AttributeValue> attributeValueList = attribute.getValues();
                for (AttributeValue attributeVal : attributeValueList) {
                    attributeValues.add(attributeVal);
                }
            }
        }
        if (attributeValues.isEmpty()) {
            return this.callHelper(type, id, issuer, category);
        }
        return new EvaluationResult(new BagAttribute(type, attributeValues));
    }

    @Override
    public EvaluationResult getAttribute(String path, URI type, URI category, URI contextSelector, String xpathVersion) {
        Attributes attributes;
        Node content;
        if (this.pdpConfig.getAttributeFinder() == null) {
            logger.warn((Object)"Context tried to invoke AttributeFinder but was not configured with one");
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        List<Attributes> attributesSet = null;
        if (category != null) {
            attributesSet = this.mapAttributes.get(category.toString());
        }
        if (attributesSet != null && attributesSet.size() > 0 && (content = (attributes = attributesSet.get(0)).getContent()) instanceof Node) {
            Node root = content;
            if (contextSelector != null && contextSelector.toString().trim().length() > 0) {
                for (Attribute attribute : attributes.getAttributes()) {
                    if (!attribute.getId().equals(contextSelector)) continue;
                    List<AttributeValue> values = attribute.getValues();
                    for (AttributeValue value : values) {
                        XPathAttribute xPathAttribute;
                        if (!(value instanceof XPathAttribute) || !(xPathAttribute = (XPathAttribute)value).getXPathCategory().equals(category.toString())) continue;
                        return this.pdpConfig.getAttributeFinder().findAttribute(path, xPathAttribute.getValue(), type, root, this, xpathVersion);
                    }
                }
            } else {
                return this.pdpConfig.getAttributeFinder().findAttribute(path, null, type, root, this, xpathVersion);
            }
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(type));
    }

    @Override
    public int getXacmlVersion() {
        return this.requestCtx.getXacmlVersion();
    }

    private void setupAttributes(Set<Attributes> attributeSet, Map<String, List<Attributes>> mapAttributes) {
        for (Attributes attributes : attributeSet) {
            List<Object> set;
            String category = attributes.getCategory().toString();
            for (Attribute attribute : attributes.getAttributes()) {
                if ("urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(category)) {
                    if ("urn:oasis:names:tc:xacml:2.0:resource:scope".equals(attribute.getId().toString())) {
                        this.resourceScopeAttribute = attribute;
                        AttributeValue value = attribute.getValue();
                        if (value instanceof StringAttribute) {
                            String scope = ((StringAttribute)value).getValue();
                            if (scope.equals("Children")) {
                                this.resourceScope = 1;
                            } else if (scope.equals("Descendants")) {
                                this.resourceScope = 2;
                            }
                        } else {
                            logger.error((Object)"scope attribute must be a string");
                        }
                    }
                    if ("urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getId().toString()) && this.resourceId == null) {
                        this.resourceId = attribute;
                    }
                }
                if (!attribute.getId().toString().equals("urn:oasis:names:tc:xacml:3.0:profile:multiple:content-selector")) continue;
                if (this.multipleContentSelectors == null) {
                    this.multipleContentSelectors = new HashSet<Attributes>();
                }
                this.multipleContentSelectors.add(attributes);
            }
            if (mapAttributes.containsKey(category)) {
                set = mapAttributes.get(category);
                set.add(attributes);
                this.multipleAttributes = true;
                continue;
            }
            set = new ArrayList();
            set.add(attributes);
            mapAttributes.put(category, set);
        }
    }

    @Override
    public MultipleCtxResult getMultipleEvaluationCtx() {
        MultipleCtxResult result;
        HashSet newSet;
        MultipleCtxResult result2;
        HashSet<EvaluationCtx> evaluationCtxSet = new HashSet<EvaluationCtx>();
        MultiRequests multiRequests = this.requestCtx.getMultiRequests();
        if (multiRequests != null) {
            result2 = this.processMultiRequestElement(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            newSet = new HashSet(evaluationCtxSet);
            for (EvaluationCtx evaluationCtx : newSet) {
                if (!((XACML3EvaluationCtx)evaluationCtx).isMultipleAttributes()) continue;
                evaluationCtxSet.remove(evaluationCtx);
                result = this.processMultipleAttributes((XACML3EvaluationCtx)evaluationCtx);
                if (result.isIndeterminate()) {
                    return result;
                }
                evaluationCtxSet.addAll(result.getEvaluationCtxSet());
            }
        } else if (this.multipleAttributes) {
            result2 = this.processMultipleAttributes(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            newSet = new HashSet(evaluationCtxSet);
            for (EvaluationCtx evaluationCtx : newSet) {
                if (((XACML3EvaluationCtx)evaluationCtx).getResourceScope() != 0) {
                    evaluationCtxSet.remove(evaluationCtx);
                    result = this.processHierarchicalAttributes((XACML3EvaluationCtx)evaluationCtx);
                    if (result.isIndeterminate()) {
                        return result;
                    }
                    evaluationCtxSet.addAll(result.getEvaluationCtxSet());
                    continue;
                }
                if (((XACML3EvaluationCtx)evaluationCtx).getMultipleContentSelectors() == null) continue;
                result = this.processMultipleContentSelectors((XACML3EvaluationCtx)evaluationCtx);
                if (result.isIndeterminate()) {
                    return result;
                }
                evaluationCtxSet.addAll(result.getEvaluationCtxSet());
            }
        } else if (this.resourceScope != 0) {
            result2 = this.processHierarchicalAttributes(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        } else if (this.multipleContentSelectors != null) {
            result2 = this.processMultipleContentSelectors(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            return new MultipleCtxResult(evaluationCtxSet);
        }
        evaluationCtxSet.add(this);
        return new MultipleCtxResult(evaluationCtxSet);
    }

    private MultipleCtxResult processMultiRequestElement(XACML3EvaluationCtx evaluationCtx) {
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        MultiRequests multiRequests = this.requestCtx.getMultiRequests();
        if (multiRequests == null) {
            return new MultipleCtxResult(children);
        }
        Set<RequestReference> requestReferences = multiRequests.getRequestReferences();
        for (RequestReference reference : requestReferences) {
            Set<AttributesReference> attributesReferences = reference.getReferences();
            if (attributesReferences == null || attributesReferences.size() <= 0) continue;
            HashSet<Attributes> attributes = new HashSet<Attributes>();
            for (AttributesReference attributesReference : attributesReferences) {
                String referenceId = attributesReference.getId();
                if (referenceId == null) continue;
                Attributes newAttributes = null;
                for (Attributes attribute : evaluationCtx.getAttributesSet()) {
                    if (attribute.getId() == null || !attribute.getId().equals(referenceId)) continue;
                    newAttributes = attribute;
                }
                if (newAttributes != null) {
                    attributes.add(newAttributes);
                    continue;
                }
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
                return new MultipleCtxResult(new Status(code, "Invalid reference to attributes"));
            }
            RequestCtx ctx = new RequestCtx(attributes, null);
            children.add(new XACML3EvaluationCtx(ctx, this.pdpConfig));
        }
        return new MultipleCtxResult(children);
    }

    private MultipleCtxResult processMultipleAttributes(XACML3EvaluationCtx evaluationCtx) {
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        Map<String, List<Attributes>> mapAttributes = evaluationCtx.getMapAttributes();
        HashSet tempRequestAttributes = new HashSet<Set>(Arrays.asList(evaluationCtx.getAttributesSet()));
        for (Map.Entry<String, List<Attributes>> entry : mapAttributes.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            HashSet temp = new HashSet();
            for (Attributes attributesElement : entry.getValue()) {
                for (Set set : tempRequestAttributes) {
                    HashSet<Attributes> newSet = new HashSet<Attributes>(set);
                    newSet.removeAll((Collection)entry.getValue());
                    newSet.add(attributesElement);
                    temp.add(newSet);
                }
            }
            tempRequestAttributes = temp;
        }
        for (Set set : tempRequestAttributes) {
            RequestCtx requestCtx = new RequestCtx(set, null);
            children.add(new XACML3EvaluationCtx(requestCtx, this.pdpConfig));
        }
        return new MultipleCtxResult(children);
    }

    private MultipleCtxResult processHierarchicalAttributes(XACML3EvaluationCtx evaluationCtx) {
        ResourceFinderResult resourceResult = null;
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        Attribute resourceId = evaluationCtx.getResourceId();
        if (resourceId != null) {
            if (evaluationCtx.getResourceScope() == 1) {
                resourceResult = this.pdpConfig.getResourceFinder().findChildResources(resourceId.getValue(), evaluationCtx);
            } else if (evaluationCtx.getResourceScope() == 2) {
                resourceResult = this.pdpConfig.getResourceFinder().findDescendantResources(resourceId.getValue(), evaluationCtx);
            } else {
                logger.error((Object)"Unknown scope type: ");
            }
        } else {
            logger.error((Object)"ResourceId Attribute is NULL: ");
        }
        if (resourceResult == null || resourceResult.isEmpty()) {
            logger.error((Object)"Resource Finder result is NULL: ");
        } else {
            for (AttributeValue resource : resourceResult.getResources()) {
                HashSet<Attributes> newSet = new HashSet<Attributes>(evaluationCtx.getAttributesSet());
                Attributes resourceAttributes = null;
                for (Attributes attributes : newSet) {
                    if (!"urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(attributes.getCategory().toString())) continue;
                    HashSet<Attribute> attributeSet = new HashSet<Attribute>(attributes.getAttributes());
                    attributeSet.remove(this.resourceScopeAttribute);
                    attributeSet.remove(resourceId);
                    try {
                        Attribute attribute = new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id"), resourceId.getIssuer(), null, resource, resourceId.isIncludeInResult(), 3);
                        attributeSet.add(attribute);
                        Attributes newAttributes = new Attributes(new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:resource"), attributes.getContent(), attributeSet, attributes.getId());
                        newSet.add(newAttributes);
                        resourceAttributes = attributes;
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    break;
                }
                if (resourceAttributes == null) continue;
                newSet.remove(resourceAttributes);
                children.add(new XACML3EvaluationCtx(new RequestCtx(newSet, null), this.pdpConfig));
            }
        }
        return new MultipleCtxResult(children);
    }

    private MultipleCtxResult processMultipleContentSelectors(XACML3EvaluationCtx evaluationCtx) {
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        HashSet<Attributes> newAttributesSet = new HashSet<Attributes>();
        for (Attributes attributes : evaluationCtx.getMultipleContentSelectors()) {
            HashSet<Attribute> newAttributes = null;
            Attribute oldAttribute = null;
            Node content = attributes.getContent();
            if (content == null || !(content instanceof Node)) continue;
            Node root = content;
            Iterator<Attribute> iterator = attributes.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute;
                oldAttribute = attribute = iterator.next();
                if (!attribute.getId().toString().equals("urn:oasis:names:tc:xacml:3.0:profile:multiple:content-selector")) continue;
                List<AttributeValue> values = attribute.getValues();
                for (AttributeValue value : values) {
                    XPathAttribute xPathAttribute;
                    if (!(value instanceof XPathAttribute) || !(xPathAttribute = (XPathAttribute)value).getXPathCategory().equals(attributes.getCategory().toString())) continue;
                    Set<String> xPaths = this.getChildXPaths(root, xPathAttribute.getValue());
                    for (String xPath : xPaths) {
                        try {
                            AttributeValue newValue = Balana.getInstance().getAttributeFactory().createValue(value.getType(), xPath, new String[]{xPathAttribute.getXPathCategory()});
                            Attribute newAttribute = new Attribute(new URI("urn:oasis:names:tc:xacml:3.0:content-selector"), attribute.getIssuer(), attribute.getIssueInstant(), newValue, attribute.isIncludeInResult(), 3);
                            if (newAttributes == null) {
                                newAttributes = new HashSet<Attribute>();
                            }
                            newAttributes.add(newAttribute);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                }
            }
            if (newAttributes == null) continue;
            attributes.getAttributes().remove(oldAttribute);
            for (Attribute attribute : newAttributes) {
                HashSet<Attribute> set = new HashSet<Attribute>(attributes.getAttributes());
                set.add(attribute);
                Attributes attr = new Attributes(attributes.getCategory(), attributes.getContent(), set, attributes.getId());
                newAttributesSet.add(attr);
            }
            evaluationCtx.getAttributesSet().remove(attributes);
        }
        for (Attributes attributes : newAttributesSet) {
            HashSet<Attributes> set = new HashSet<Attributes>(evaluationCtx.getAttributesSet());
            set.add(attributes);
            RequestCtx requestCtx = new RequestCtx(set, null);
            children.add(new XACML3EvaluationCtx(requestCtx, this.pdpConfig));
        }
        return new MultipleCtxResult(children);
    }

    public void setResourceId(AttributeValue resourceId, Set<Attributes> attributesSet) {
        for (Attributes attributes : attributesSet) {
            if (!"urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(attributes.getCategory().toString())) continue;
            Set<Attribute> attributeSet = attributes.getAttributes();
            HashSet<Attribute> newSet = new HashSet<Attribute>(attributeSet);
            Attribute resourceIdAttribute = null;
            for (Attribute attribute : newSet) {
                if ("urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getId().toString())) {
                    resourceIdAttribute = attribute;
                    attributeSet.remove(attribute);
                    continue;
                }
                if (!"urn:oasis:names:tc:xacml:2.0:resource:scope".equals(attribute.getId().toString())) continue;
                attributeSet.remove(attribute);
            }
            if (resourceIdAttribute == null) break;
            attributeSet.add(new Attribute(resourceIdAttribute.getId(), resourceIdAttribute.getIssuer(), resourceIdAttribute.getIssueInstant(), resourceId, resourceIdAttribute.isIncludeInResult(), 3));
            break;
        }
    }

    private Set<String> getChildXPaths(Node root, String xPath) {
        HashSet<String> xPaths = new HashSet<String>();
        DefaultNamespaceContext namespaceContext = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (namespaceContext == null) {
            String namespace = null;
            if (root != null) {
                namespace = root.getNamespaceURI();
            }
            NamedNodeMap namedNodeMap = root.getAttributes();
            HashMap<String, String> nsMap = new HashMap<String, String>();
            if (namedNodeMap != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node n = namedNodeMap.item(i);
                    String prefix = DOMHelper.getLocalName(n);
                    String nodeValue = n.getNodeValue();
                    nsMap.put(prefix, nodeValue);
                }
            }
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(namespace) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(namespace) || "urn:oasis:names:tc:xacml:1.0:context".equals(namespace)) {
                nsMap.put("xacml", namespace);
            }
            namespaceContext = new DefaultNamespaceContext(nsMap);
        }
        xpath.setNamespaceContext(namespaceContext);
        try {
            XPathExpression expression = xpath.compile(xPath);
            NodeList matches = (NodeList)expression.evaluate(root, XPathConstants.NODESET);
            if (matches != null && matches.getLength() > 0) {
                for (int i = 0; i < matches.getLength(); ++i) {
                    String text = null;
                    Node node = matches.item(i);
                    short nodeType = node.getNodeType();
                    text = nodeType == 4 || nodeType == 8 || nodeType == 3 || nodeType == 2 ? node.getNodeValue() : "/" + DOMHelper.getLocalName(node);
                    String newXPath = '(' + xPath + ")[" + (i + 1) + ']';
                    xPaths.add(newXPath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xPaths;
    }

    public boolean isMultipleAttributes() {
        return this.multipleAttributes;
    }

    @Override
    public AbstractRequestCtx getRequestCtx() {
        return this.requestCtx;
    }

    public Set<PolicyReference> getPolicyReferences() {
        return this.policyReferences;
    }

    public void setPolicyReferences(Set<PolicyReference> policyReferences) {
        this.policyReferences = policyReferences;
    }

    public List<Attributes> getAttributes(String category) {
        return this.mapAttributes.get(category);
    }

    public Set<Attributes> getMultipleContentSelectors() {
        return this.multipleContentSelectors;
    }

    public Map<String, List<Attributes>> getMapAttributes() {
        return this.mapAttributes;
    }

    public Set<Attributes> getAttributesSet() {
        return this.attributesSet;
    }

    public Attribute getResourceId() {
        return this.resourceId;
    }

    public int getResourceScope() {
        return this.resourceScope;
    }

    public Attribute getResourceScopeAttribute() {
        return this.resourceScopeAttribute;
    }
}

