/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.xacml3.XACML3EvaluationCtx;
import org.wso2.balana.xacml3.Advice;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.balana.xacml3.Obligation;

public class Result
extends AbstractResult {
    Set<PolicyReference> policyReferences;
    Set<Attributes> attributes;

    public Result(int decision, Status status) {
        super(decision, status, 3);
    }

    public Result(int decision, Status status, List<ObligationResult> obligationResults, List<Advice> advices, EvaluationCtx evaluationCtx) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, 3);
        if (evaluationCtx != null) {
            XACML3EvaluationCtx ctx = (XACML3EvaluationCtx)evaluationCtx;
            this.policyReferences = ctx.getPolicyReferences();
            this.processAttributes(ctx.getAttributesSet());
        }
    }

    public Result(int decision, Status status, List<ObligationResult> obligationResults, List<Advice> advices, Set<PolicyReference> policyReferences, Set<Attributes> attributes) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, 3);
        this.policyReferences = policyReferences;
        this.processAttributes(attributes);
    }

    public static AbstractResult getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        List<ObligationResult> obligations = null;
        List<Advice> advices = null;
        Set<PolicyReference> policyReferences = null;
        HashSet<Attributes> attributes = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = DOMHelper.getLocalName(node);
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                if (status == null) {
                    status = Status.getInstance(node);
                    continue;
                }
                throw new ParsingException("More than one StatusType defined");
            }
            if (name.equals("Obligations")) {
                if (obligations == null) {
                    obligations = Result.parseObligations(node);
                    continue;
                }
                throw new ParsingException("More than one ObligationsType defined");
            }
            if (name.equals("AssociatedAdvice")) {
                if (advices == null) {
                    advices = Result.parseAdvices(node);
                    continue;
                }
                throw new ParsingException("More than one AssociatedAdviceType defined");
            }
            if (name.equals("PolicyIdentifierList")) {
                if (policyReferences == null) {
                    policyReferences = Result.parsePolicyReferences(node);
                    continue;
                }
                throw new ParsingException("More than one PolicyIdentifierListType defined");
            }
            if (!name.equals("Attributes")) continue;
            if (attributes == null) {
                attributes = new HashSet<Attributes>();
            }
            attributes.add(Attributes.getInstance(node));
        }
        return new Result(decision, status, obligations, advices, policyReferences, attributes);
    }

    private static List<ObligationResult> parseObligations(Node root) throws ParsingException {
        ArrayList<ObligationResult> list = new ArrayList<ObligationResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("Obligation")) continue;
            list.add(Obligation.getInstance(node));
        }
        if (list.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return list;
    }

    private static List<Advice> parseAdvices(Node root) throws ParsingException {
        ArrayList<Advice> list = new ArrayList<Advice>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("Advice")) continue;
            list.add(Advice.getInstance(node));
        }
        if (list.size() == 0) {
            throw new ParsingException("AssociatedAdviceType must not be empty");
        }
        return list;
    }

    private static Set<PolicyReference> parsePolicyReferences(Node root) throws ParsingException {
        HashSet<PolicyReference> set = new HashSet<PolicyReference>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            set.add(PolicyReference.getInstance(node, null, null));
        }
        return set;
    }

    public Set<Attributes> getAttributes() {
        return this.attributes;
    }

    public void processAttributes(Set<Attributes> attributesSet) {
        if (attributesSet == null) {
            return;
        }
        HashSet<Attributes> newSet = new HashSet<Attributes>();
        for (Attributes attributes : attributesSet) {
            Set<Attribute> attributeSet = attributes.getAttributes();
            if (attributeSet == null) continue;
            HashSet<Attribute> newAttributeSet = new HashSet<Attribute>();
            for (Attribute attribute : attributeSet) {
                if (!attribute.isIncludeInResult()) continue;
                newAttributeSet.add(attribute);
            }
            if (newAttributeSet.size() <= 0) continue;
            Attributes newAttributes = new Attributes(attributes.getCategory(), attributes.getContent(), newAttributeSet, attributes.getId());
            newSet.add(newAttributes);
        }
        this.attributes = newSet;
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Result>");
        if (this.decision == 4 || this.decision == 5 || this.decision == 6) {
            builder.append("<Decision>").append(DECISIONS[2]).append("</Decision>");
        } else {
            builder.append("<Decision>").append(DECISIONS[this.decision]).append("</Decision>");
        }
        if (this.status != null) {
            this.status.encode(builder);
        }
        if (this.obligations != null && this.obligations.size() != 0) {
            builder.append("<Obligations>");
            for (Obligation obligation : this.obligations) {
                obligation.encode(builder);
            }
            builder.append("</Obligations>");
        }
        if (this.advices != null && this.advices.size() != 0) {
            builder.append("<AssociatedAdvice>");
            for (Advice advice : this.advices) {
                advice.encode(builder);
            }
            builder.append("</AssociatedAdvice>");
        }
        if (this.policyReferences != null && this.policyReferences.size() != 0) {
            builder.append("<PolicyIdentifierList>");
            for (PolicyReference reference : this.policyReferences) {
                reference.encode(builder);
            }
            builder.append("</PolicyIdentifierList>");
        }
        if (this.attributes != null && this.attributes.size() != 0) {
            for (Attributes attribute : this.attributes) {
                attribute.encode(builder);
            }
        }
        builder.append("</Result>");
    }
}

