/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml2;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml2.Obligation;

public class Result
extends AbstractResult {
    private String resourceId = null;

    public Result(int decision, Status status) {
        super(decision, status, 2);
    }

    public Result(int decision, Status status, List<ObligationResult> obligationResults) throws IllegalArgumentException {
        super(decision, status, obligationResults, null, 2);
    }

    public Result(int decision, Status status, List<ObligationResult> obligationResults, String resourceId) throws IllegalArgumentException {
        super(decision, status, obligationResults, null, 2);
        this.resourceId = resourceId;
    }

    public static AbstractResult getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        String resource = null;
        List<ObligationResult> obligations = null;
        NamedNodeMap attrs = root.getAttributes();
        Node resourceAttr = attrs.getNamedItem("ResourceId");
        if (resourceAttr != null) {
            resource = resourceAttr.getNodeValue();
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = DOMHelper.getLocalName(node);
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                if (status == null) {
                    status = Status.getInstance(node);
                    continue;
                }
                throw new ParsingException("More than one StatusType defined");
            }
            if (!name.equals("Obligations")) continue;
            if (obligations == null) {
                obligations = Result.parseObligations(node);
                continue;
            }
            throw new ParsingException("More than one ObligationsType defined");
        }
        return new Result(decision, status, obligations, resource);
    }

    private static List<ObligationResult> parseObligations(Node root) throws ParsingException {
        ArrayList<ObligationResult> list = new ArrayList<ObligationResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("Obligation")) continue;
            list.add(Obligation.getInstance(node));
        }
        if (list.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return list;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean setResource(String resource) {
        if (this.resourceId != null) {
            return false;
        }
        this.resourceId = resource;
        return true;
    }

    @Override
    public void encode(StringBuilder builder) {
        if (this.resourceId == null) {
            builder.append("<Result>");
        } else {
            builder.append("<Result ResourceId=\"").append(this.resourceId).append("\">");
        }
        builder.append("<Decision>").append(DECISIONS[this.decision]).append("</Decision>");
        if (this.status != null) {
            this.status.encode(builder);
        }
        if (this.obligations != null && this.obligations.size() != 0) {
            builder.append("<Obligations>");
            for (ObligationResult obligation : this.obligations) {
                obligation.encode(builder);
            }
            builder.append("</Obligations>");
        }
        builder.append("</Result>");
    }
}

