/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.MissingAttributeDetail;
import org.wso2.balana.utils.Utils;
import org.xml.sax.SAXException;

public class StatusDetail {
    private String detailText = null;
    private List<MissingAttributeDetail> missingAttributeDetails;

    public StatusDetail(List<MissingAttributeDetail> missingAttributeDetails) throws IllegalArgumentException {
        this.missingAttributeDetails = missingAttributeDetails;
        try {
            this.detailText = "<StatusDetail>\n";
            for (MissingAttributeDetail attribute : missingAttributeDetails) {
                this.detailText = this.detailText + attribute.getEncoded() + "\n";
            }
            this.detailText = this.detailText + "</StatusDetail>";
        }
        catch (ParsingException pe) {
            throw new IllegalArgumentException("Invalid MissingAttributeDetail data, caused by " + pe.getMessage());
        }
    }

    public StatusDetail(String encoded) throws ParsingException {
        this.detailText = "<StatusDetail>\n" + encoded + "\n</StatusDetail>";
    }

    private StatusDetail(Node root) {
        try {
            this.detailText = this.nodeToText(root);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    private Node textToNode(String encoded) throws ParsingException {
        try {
            String text = "<?xml version=\"1.0\"?>\n";
            byte[] bytes = (text + encoded).getBytes();
            DocumentBuilderFactory documentBuilderFactory = Utils.getSecuredDocumentBuilderFactory();
            DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParsingException("invalid XML for status detail", e);
        }
    }

    private String nodeToText(Node node) throws ParsingException {
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            throw new ParsingException("invalid XML for status detail");
        }
        return sw.toString();
    }

    public static StatusDetail getInstance(Node root) throws ParsingException {
        if (!DOMHelper.getLocalName(root).equals("StatusDetail")) {
            throw new ParsingException("not a StatusDetail node");
        }
        return new StatusDetail(root);
    }

    public List<MissingAttributeDetail> getMissingAttributeDetails() {
        return this.missingAttributeDetails;
    }

    public String getEncoded() throws IllegalStateException {
        if (this.detailText == null) {
            throw new IllegalStateException("no encoded form available");
        }
        return this.detailText;
    }
}

