/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.StatusDetail;

public class Status {
    public static final String STATUS_OK = "urn:oasis:names:tc:xacml:1.0:status:ok";
    public static final String STATUS_MISSING_ATTRIBUTE = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
    public static final String STATUS_SYNTAX_ERROR = "urn:oasis:names:tc:xacml:1.0:status:syntax-error";
    public static final String STATUS_PROCESSING_ERROR = "urn:oasis:names:tc:xacml:1.0:status:processing-error";
    private List<String> code;
    private String message;
    private StatusDetail detail;
    private static Status okStatus;

    public Status(List<String> code) {
        this(code, null, null);
    }

    public Status(List<String> code, String message) {
        this(code, message, null);
    }

    public Status(List<String> code, String message, StatusDetail detail) throws IllegalArgumentException {
        String c;
        if (detail != null && ((c = code.iterator().next()).equals(STATUS_OK) || c.equals(STATUS_SYNTAX_ERROR) || c.equals(STATUS_PROCESSING_ERROR))) {
            throw new IllegalArgumentException("status detail cannot be included with " + c);
        }
        this.code = Collections.unmodifiableList(new ArrayList<String>(code));
        this.message = message;
        this.detail = detail;
    }

    public List<String> getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public StatusDetail getDetail() {
        return this.detail;
    }

    public static Status getOkInstance() {
        return okStatus;
    }

    public static Status getInstance(Node root) throws ParsingException {
        List<String> code = null;
        String message = null;
        StatusDetail detail = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = DOMHelper.getLocalName(node);
            if (name.equals("StatusCode")) {
                code = Status.parseStatusCode(node);
                continue;
            }
            if (name.equals("StatusMessage")) {
                message = node.getFirstChild().getNodeValue();
                continue;
            }
            if (!name.equals("StatusDetail")) continue;
            detail = StatusDetail.getInstance(node);
        }
        if (code == null) {
            throw new ParsingException("Missing required element StatusCode in StatusType");
        }
        return new Status(code, message, detail);
    }

    private static List<String> parseStatusCode(Node root) {
        String val = root.getAttributes().getNamedItem("Value").getNodeValue();
        ArrayList<String> code = new ArrayList<String>();
        code.add(val);
        NodeList list = ((Element)root).getElementsByTagName("StatusCode");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            code.add(node.getAttributes().getNamedItem("Value").getNodeValue());
        }
        return code;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        builder.append("<Status>");
        this.encodeStatusCode(this.code.iterator(), builder);
        if (this.message != null) {
            builder.append("<StatusMessage>").append(this.message).append("</StatusMessage>");
        }
        if (this.detail != null) {
            builder.append(this.detail.getEncoded());
        }
        builder.append("</Status>");
    }

    private void encodeStatusCode(Iterator<String> iterator, StringBuilder builder) {
        String code = iterator.next();
        if (iterator.hasNext()) {
            builder.append("<StatusCode Value=\"").append(code).append("\">");
            this.encodeStatusCode(iterator, builder);
            builder.append("</StatusCode>");
        } else {
            builder.append("<StatusCode Value=\"").append(code).append("\"/>");
        }
    }

    static {
        ArrayList<String> code = new ArrayList<String>();
        code.add(STATUS_OK);
        okStatus = new Status(code);
    }
}

