/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.util.List;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.xacml3.Result;
import org.wso2.balana.xacml3.Advice;

public class ResultFactory {
    private static volatile ResultFactory factoryInstance;

    public AbstractResult getResult(int decision, Status status, int version) {
        if (version == 3) {
            return new Result(decision, status, null, null, null);
        }
        return new org.wso2.balana.ctx.xacml2.Result(decision, status);
    }

    public AbstractResult getResult(int decision, EvaluationCtx evaluationCtx) {
        if (evaluationCtx.getXacmlVersion() == 3) {
            return new Result(decision, null, null, null, evaluationCtx);
        }
        return new org.wso2.balana.ctx.xacml2.Result(decision, null);
    }

    public AbstractResult getResult(int decision, Status status, EvaluationCtx evaluationCtx) {
        if (evaluationCtx.getXacmlVersion() == 3) {
            return new Result(decision, status, null, null, evaluationCtx);
        }
        return new org.wso2.balana.ctx.xacml2.Result(decision, status);
    }

    public AbstractResult getResult(int decision, List<ObligationResult> obligationResults, List<Advice> advices, EvaluationCtx evaluationCtx) {
        if (evaluationCtx.getXacmlVersion() == 3) {
            return new Result(decision, null, obligationResults, advices, evaluationCtx);
        }
        return new org.wso2.balana.ctx.xacml2.Result(decision, null, obligationResults);
    }

    public AbstractResult getResult(int decision, Status status, List<ObligationResult> obligationResults, List<Advice> advices, EvaluationCtx evaluationCtx) {
        if (evaluationCtx.getXacmlVersion() == 3) {
            return new Result(decision, status, obligationResults, advices, evaluationCtx);
        }
        return new org.wso2.balana.ctx.xacml2.Result(decision, status, obligationResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<ResultFactory> clazz = ResultFactory.class;
        synchronized (ResultFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            factoryInstance = new ResultFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }
}

