/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.InputParser;
import org.wso2.balana.ctx.xacml3.RequestCtx;
import org.wso2.balana.utils.Utils;

public class RequestCtxFactory {
    private static volatile RequestCtxFactory factoryInstance;
    private static final Log log;

    public AbstractRequestCtx getRequestCtx(Node root) throws ParsingException {
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return RequestCtx.getInstance(root);
            }
            if ("urn:oasis:names:tc:xacml:1.0:context".equals(requestCtxNs.trim()) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(requestCtxNs.trim())) {
                return org.wso2.balana.ctx.xacml2.RequestCtx.getInstance(root);
            }
            throw new ParsingException("Invalid namespace in XACML request");
        }
        log.warn((Object)"No Namespace defined in XACML request and Assume as XACML 3.0");
        return RequestCtx.getInstance(root);
    }

    public AbstractRequestCtx getRequestCtx(String request) throws ParsingException {
        Element root = this.getXacmlRequest(request);
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return RequestCtx.getInstance(root);
            }
            if ("urn:oasis:names:tc:xacml:1.0:context".equals(requestCtxNs.trim()) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(requestCtxNs.trim())) {
                return org.wso2.balana.ctx.xacml2.RequestCtx.getInstance(root);
            }
            throw new ParsingException("Invalid namespace in XACML request");
        }
        log.warn((Object)"No Namespace defined in XACML request and Assume as XACML 3.0");
        return RequestCtx.getInstance(root);
    }

    public AbstractRequestCtx getRequestCtx(InputStream input) throws ParsingException {
        Node root = InputParser.parseInput(input, "Request");
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return RequestCtx.getInstance(root);
            }
            if ("urn:oasis:names:tc:xacml:1.0:context".equals(requestCtxNs.trim()) || "urn:oasis:names:tc:xacml:2.0:context:schema:os".equals(requestCtxNs.trim())) {
                return org.wso2.balana.ctx.xacml2.RequestCtx.getInstance(root);
            }
            throw new ParsingException("Invalid namespace in XACML request");
        }
        log.warn((Object)"No Namespace defined in XACML request and Assume as XACML 3.0");
        return RequestCtx.getInstance(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestCtxFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<RequestCtxFactory> clazz = RequestCtxFactory.class;
        synchronized (RequestCtxFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            factoryInstance = new RequestCtxFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }

    public Element getXacmlRequest(String request) throws ParsingException {
        Document doc;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBytes());
        DocumentBuilderFactory builder = Utils.getSecuredDocumentBuilderFactory();
        if (builder == null) {
            throw new ParsingException("DOM Builder can not be null");
        }
        try {
            doc = builder.newDocumentBuilder().parse(inputStream);
        }
        catch (Exception e) {
            throw new ParsingException("DOM of request element can not be created from String", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing input stream of XACML request");
            }
        }
        return doc.getDocumentElement();
    }

    static {
        log = LogFactory.getLog(RequestCtxFactory.class);
    }
}

