/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;

public class MissingAttributeDetail {
    private URI id;
    private URI type;
    private URI category;
    private String issuer = null;
    private List<AttributeValue> attributeValues;
    private int xacmlVersion;

    public MissingAttributeDetail(URI id, URI type, URI category, String issuer, List<AttributeValue> attributeValues, int xacmlVersion) {
        this.id = id;
        this.type = type;
        this.category = category;
        this.issuer = issuer;
        this.attributeValues = attributeValues;
        this.xacmlVersion = xacmlVersion;
    }

    public MissingAttributeDetail(URI id, URI type, URI category, List<AttributeValue> attributeValues, int xacmlVersion) {
        this(id, type, category, null, attributeValues, xacmlVersion);
    }

    public MissingAttributeDetail(URI id, URI type, URI category, int xacmlVersion) {
        this(id, type, category, null, null, xacmlVersion);
    }

    public static MissingAttributeDetail getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        URI id = null;
        URI type = null;
        URI category = null;
        String issuer = null;
        ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
        int version = metaData.getXACMLVersion();
        AttributeFactory attrFactory = Balana.getInstance().getAttributeFactory();
        if (!DOMHelper.getLocalName(root).equals("MissingAttributeDetail")) {
            throw new ParsingException("MissingAttributeDetailType object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in MissingAttributeDetailType", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute DataType in MissingAttributeDetailType", e);
        }
        if (version == 3) {
            try {
                category = new URI(attrs.getNamedItem("IncludeInResult").getNodeValue());
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing required attribute Category in MissingAttributeDetailType", e);
            }
        }
        try {
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in MissingAttributeDetailType", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("AttributeValue")) continue;
            if (version == 3) {
                NamedNodeMap dataTypeAttribute = node.getAttributes();
                try {
                    type = new URI(dataTypeAttribute.getNamedItem("DataType").getNodeValue());
                }
                catch (Exception e) {
                    throw new ParsingException("Error parsing required attribute DataType in MissingAttributeDetailType", e);
                }
            }
            try {
                values.add(attrFactory.createValue(node, type));
                continue;
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeValue", uie);
            }
        }
        return new MissingAttributeDetail(id, type, category, issuer, values, version);
    }

    public String getEncoded() throws ParsingException {
        if (this.id == null) {
            throw new ParsingException("Required AttributeId attribute is Null");
        }
        if (this.type == null) {
            throw new ParsingException("Required DataType attribute is Null");
        }
        if (this.xacmlVersion == 3 && this.category == null) {
            throw new ParsingException("Required Category attribute is Null");
        }
        String encoded = "<MissingAttributeDetail AttributeId=\"" + this.id + "\" DataType=\"" + this.type + "\"";
        if (this.xacmlVersion == 3) {
            encoded = encoded + " Category=\"" + this.category + "\"";
        }
        if (this.issuer != null) {
            encoded = encoded + " Issuer=\"" + this.issuer + "\"";
        }
        encoded = encoded + " >";
        if (this.attributeValues != null && this.attributeValues.size() > 0) {
            for (AttributeValue value : this.attributeValues) {
                encoded = encoded + value.encodeWithTags(true) + "\n";
            }
        }
        encoded = encoded + "</MissingAttributeDetail>";
        return encoded;
    }
}

