/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;

public class AttributeAssignment
extends AttributeValue {
    private URI attributeId;
    private URI category;
    private String issuer;
    private String content;

    public AttributeAssignment(URI attributeId, URI dataType, URI category, String content, String issuer) {
        super(dataType);
        this.attributeId = attributeId;
        this.category = category;
        this.issuer = issuer;
        this.content = content;
    }

    public static AttributeAssignment getInstance(Node root) throws ParsingException {
        URI type;
        URI attributeId;
        URI category = null;
        String issuer = null;
        String content = null;
        if (!DOMHelper.getLocalName(root).equals("AttributeAssignment")) {
            throw new ParsingException("AttributeAssignment object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            attributeId = new URI(nodeAttributes.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            type = new URI(nodeAttributes.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            Node issuerNode;
            Node categoryNode = nodeAttributes.getNamedItem("Category");
            if (categoryNode != null) {
                category = new URI(categoryNode.getNodeValue());
            }
            if ((issuerNode = nodeAttributes.getNamedItem("Issuer")) != null) {
                issuer = issuerNode.getNodeValue();
            }
            content = root.getTextContent();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeAssignmentType", e);
        }
        return new AttributeAssignment(attributeId, type, category, content, issuer);
    }

    public URI getAttributeId() {
        return this.attributeId;
    }

    public URI getCategory() {
        return this.category;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<AttributeAssignment  AttributeId=\"").append(this.attributeId).append("\"");
        builder.append(" DataType=\"").append(this.getType()).append("\"");
        if (this.category != null) {
            builder.append(" Category=\"").append(this.category).append("\"");
        }
        if (this.issuer != null) {
            builder.append("\" Issuer=\"").append(this.issuer).append("\"");
        }
        builder.append(">");
        if (this.content != null) {
            builder.append(this.content);
        }
        builder.append("</AttributeAssignment>\n");
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }
}

