/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.DateTimeAttribute;

public class Attribute {
    private URI id;
    private URI type;
    private boolean includeInResult;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private List<AttributeValue> attributeValues;
    private int xacmlVersion;

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value, boolean includeInResult, int version) {
        this(id, value.getType(), issuer, issueInstant, Arrays.asList(value), includeInResult, version);
    }

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value, int version) {
        this(id, value.getType(), issuer, issueInstant, Arrays.asList(value), false, version);
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, List<AttributeValue> attributeValues, boolean includeInResult, int xacmlVersion) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.attributeValues = attributeValues;
        this.includeInResult = includeInResult;
        this.xacmlVersion = xacmlVersion;
    }

    public static Attribute getInstance(Node root, int version) throws ParsingException {
        URI id = null;
        URI type = null;
        String issuer = null;
        DateTimeAttribute issueInstant = null;
        ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
        boolean includeInResult = false;
        AttributeFactory attributeFactory = Balana.getInstance().getAttributeFactory();
        if (!DOMHelper.getLocalName(root).equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", e);
        }
        if (version != 3) {
            try {
                type = new URI(attrs.getNamedItem("DataType").getNodeValue());
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
            }
        }
        if (version == 3) {
            try {
                String includeInResultString = attrs.getNamedItem("IncludeInResult").getNodeValue();
                if ("true".equals(includeInResultString)) {
                    includeInResult = true;
                }
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing required attribute IncludeInResult in AttributeType", e);
            }
        }
        try {
            Node instantNode;
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
            if (version != 3 && (instantNode = attrs.getNamedItem("IssueInstant")) != null) {
                issueInstant = DateTimeAttribute.getInstance(instantNode.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional AttributeType attribute", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("AttributeValue")) continue;
            if (version == 3) {
                NamedNodeMap dataTypeAttribute = node.getAttributes();
                try {
                    type = new URI(dataTypeAttribute.getNamedItem("DataType").getNodeValue());
                }
                catch (Exception e) {
                    throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
                }
            }
            try {
                values.add(attributeFactory.createValue(node, type));
                continue;
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException(uie.getMessage(), uie);
            }
        }
        if (values.size() < 1) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(id, type, issuer, issueInstant, values, includeInResult, version);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public boolean isIncludeInResult() {
        return this.includeInResult;
    }

    public List<AttributeValue> getValues() {
        return this.attributeValues;
    }

    public AttributeValue getValue() {
        if (this.attributeValues != null) {
            return this.attributeValues.get(0);
        }
        return null;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public void encode(StringBuilder builder) {
        builder.append("<Attribute AttributeId=\"").append(this.id.toString()).append("\"");
        if (this.xacmlVersion == 3) {
            builder.append(" IncludeInResult=\"").append(this.includeInResult).append("\"");
        } else {
            builder.append(" DataType=\"").append(this.type.toString()).append("\"");
            if (this.issueInstant != null) {
                builder.append(" IssueInstant=\"").append(this.issueInstant.encode()).append("\"");
            }
        }
        if (this.issuer != null) {
            builder.append(" Issuer=\"").append(this.issuer).append("\"");
        }
        builder.append(">\n");
        if (this.attributeValues != null && this.attributeValues.size() > 0) {
            for (AttributeValue value : this.attributeValues) {
                value.encode(builder);
            }
        }
        builder.append("</Attribute>\n");
    }
}

