/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.util.ArrayList;
import java.util.List;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.Advice;

public abstract class AbstractResult {
    public static final int DECISION_PERMIT = 0;
    public static final int DECISION_DENY = 1;
    public static final int DECISION_INDETERMINATE = 2;
    public static final int DECISION_NOT_APPLICABLE = 3;
    public static final int DECISION_INDETERMINATE_DENY = 4;
    public static final int DECISION_INDETERMINATE_PERMIT = 5;
    public static final int DECISION_INDETERMINATE_DENY_OR_PERMIT = 6;
    public static final String[] DECISIONS = new String[]{"Permit", "Deny", "Indeterminate", "NotApplicable"};
    protected List<ObligationResult> obligations;
    protected List<Advice> advices;
    protected int decision = -1;
    protected Status status = null;
    protected int version;

    public AbstractResult(int decision, Status status, int version) throws IllegalArgumentException {
        this.version = version;
        if (decision != 0 && decision != 1 && decision != 2 && decision != 3 && decision != 4 && decision != 5 && decision != 6) {
            throw new IllegalArgumentException("invalid decision value");
        }
        this.decision = decision;
        this.status = status == null ? Status.getOkInstance() : status;
    }

    public AbstractResult(int decision, Status status, List<ObligationResult> obligationResults, List<Advice> advices, int version) throws IllegalArgumentException {
        this.version = version;
        if (decision != 0 && decision != 1 && decision != 2 && decision != 3 && decision != 4 && decision != 5 && decision != 6) {
            throw new IllegalArgumentException("invalid decision value");
        }
        this.decision = decision;
        if (obligationResults != null) {
            this.obligations = obligationResults;
        }
        if (advices != null) {
            this.advices = advices;
        }
        this.status = status == null ? Status.getOkInstance() : status;
    }

    public List<ObligationResult> getObligations() {
        if (this.obligations == null) {
            this.obligations = new ArrayList<ObligationResult>();
        }
        return this.obligations;
    }

    public List<Advice> getAdvices() {
        if (this.advices == null) {
            this.advices = new ArrayList<Advice>();
        }
        return this.advices;
    }

    public int getDecision() {
        return this.decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getVersion() {
        return this.version;
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    public abstract void encode(StringBuilder var1);
}

