/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.Function;
import org.wso2.balana.ctx.EvaluationCtx;

public class XACML3HigherOrderFunction
implements Function {
    public static final String NAME_ANY_OF = "urn:oasis:names:tc:xacml:3.0:function:any-of";
    public static final String NAME_ALL_OF = "urn:oasis:names:tc:xacml:3.0:function:all-of";
    public static final String NAME_ANY_OF_ANY = "urn:oasis:names:tc:xacml:3.0:function:any-of-any";
    private static final int ID_ANY_OF = 0;
    private static final int ID_ALL_OF = 1;
    private static final int ID_ANY_OF_ANY = 2;
    private static final Map<String, Integer> ID_MAP;
    private int functionId;
    private URI identifier;
    private static URI returnTypeURI;
    private static RuntimeException earlyException;

    public XACML3HigherOrderFunction(String functionName) {
        Integer i = ID_MAP.get(functionName);
        if (i == null) {
            throw new IllegalArgumentException("Unknown function: " + functionName);
        }
        this.functionId = i;
        try {
            this.identifier = new URI(functionName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(ID_MAP.keySet());
    }

    @Override
    public void checkInputs(List inputs) throws IllegalArgumentException {
        Object[] list = inputs.toArray();
        if (list.length < 2) {
            throw new IllegalArgumentException("requires more than two inputs");
        }
        if (!(list[0] instanceof Function)) {
            throw new IllegalArgumentException("first arg to higher-order  function must be a function");
        }
        Function function = (Function)list[0];
        if (!function.getReturnType().toString().equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            throw new IllegalArgumentException("higher-order function must use a boolean function");
        }
        ArrayList<Evaluatable> bagArgs = new ArrayList<Evaluatable>();
        ArrayList<Evaluatable> args = new ArrayList<Evaluatable>();
        for (int i = 1; i < list.length; ++i) {
            Evaluatable eval = (Evaluatable)list[i];
            if (eval.returnsBag()) {
                bagArgs.add(eval);
                continue;
            }
            args.add(eval);
        }
        if (this.functionId == 1 || this.functionId == 0) {
            if (bagArgs.size() != 1) {
                throw new IllegalArgumentException("Only one argument SHALL be a bag of a primitive data-type for " + this.getIdentifier());
            }
            for (Evaluatable arg : args) {
                ArrayList<Evaluatable> inputForCheck = new ArrayList<Evaluatable>();
                inputForCheck.add(arg);
                inputForCheck.addAll(bagArgs);
                function.checkInputsNoBag(inputForCheck);
            }
        } else {
            if (!args.isEmpty() && !bagArgs.isEmpty()) {
                throw new IllegalArgumentException("The arguments can be are either primitive data types or bags of primitive types. " + this.getIdentifier());
            }
            if (!args.isEmpty()) {
                this.validateAnyOfAnyInput(args, function);
            } else {
                this.validateAnyOfAnyInput(bagArgs, function);
            }
        }
    }

    private void validateAnyOfAnyInput(List<Evaluatable> inputs, Function function) {
        for (int i = 0; i < inputs.size(); ++i) {
            for (int j = i + 1; j < inputs.size(); ++j) {
                ArrayList<Evaluatable> inputForCheck = new ArrayList<Evaluatable>();
                inputForCheck.add(inputs.get(i));
                inputForCheck.add(inputs.get(j));
                function.checkInputsNoBag(inputForCheck);
            }
        }
    }

    @Override
    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        throw new IllegalArgumentException("higher-order functions require use of bags");
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        Iterator iterator = inputs.iterator();
        Expression xpr = (Expression)iterator.next();
        Function function = null;
        if (xpr instanceof Function) {
            function = (Function)xpr;
        }
        ArrayList<AttributeValue> args = new ArrayList<AttributeValue>();
        ArrayList<BagAttribute> bagArgs = new ArrayList<BagAttribute>();
        while (iterator.hasNext()) {
            Evaluatable eval = (Evaluatable)iterator.next();
            EvaluationResult result = eval.evaluate(context);
            if (result.indeterminate()) {
                return result;
            }
            if (result.getAttributeValue().returnsBag()) {
                bagArgs.add((BagAttribute)result.getAttributeValue());
                continue;
            }
            args.add(result.getAttributeValue());
        }
        switch (this.functionId) {
            case 0: {
                return this.anyAndAllHelper(context, function, args, (BagAttribute)bagArgs.get(0), false);
            }
            case 1: {
                return this.anyAndAllHelper(context, function, args, (BagAttribute)bagArgs.get(0), true);
            }
            case 2: {
                return this.anyOfAny(context, function, args, bagArgs);
            }
        }
        return null;
    }

    private EvaluationResult anyAndAllHelper(EvaluationCtx context, Function function, List<AttributeValue> values, BagAttribute bag, boolean isAllFunction) {
        Iterator it = bag.iterator();
        while (it.hasNext()) {
            AttributeValue bagValue = (AttributeValue)it.next();
            for (AttributeValue value : values) {
                EvaluationResult result = this.getEvaluationResult(context, function, value, bagValue, isAllFunction);
                if (result == null) continue;
                return result;
            }
        }
        return new EvaluationResult(BooleanAttribute.getInstance(isAllFunction));
    }

    private EvaluationResult anyOfAny(EvaluationCtx context, Function function, List<AttributeValue> args, List<BagAttribute> bagArgs) {
        EvaluationResult result = new EvaluationResult(BooleanAttribute.getInstance(false));
        if (!args.isEmpty()) {
            for (int i = 0; i < args.size() - 1; ++i) {
                AttributeValue value = args.get(i);
                ArrayList<AttributeValue> bagValue = new ArrayList<AttributeValue>();
                bagValue.add(value);
                BagAttribute bagArg = new BagAttribute(value.getType(), bagValue);
                result = this.anyAndAllHelper(context, function, args.subList(i + 1, args.size()), bagArg, false);
                if (!result.indeterminate() && !((BooleanAttribute)result.getAttributeValue()).getValue()) continue;
                return result;
            }
            return new EvaluationResult(BooleanAttribute.getInstance(false));
        }
        if (!bagArgs.isEmpty()) {
            for (int i = 0; i < bagArgs.size(); ++i) {
                for (int j = i + 1; j < bagArgs.size(); ++j) {
                    Iterator iIterator = bagArgs.get(i).iterator();
                    while (iIterator.hasNext()) {
                        AttributeValue iValue = (AttributeValue)iIterator.next();
                        Iterator jIterator = bagArgs.get(j).iterator();
                        while (jIterator.hasNext()) {
                            AttributeValue jValue = (AttributeValue)jIterator.next();
                            result = this.getEvaluationResult(context, function, jValue, iValue, false);
                            if (result == null || !result.indeterminate() && !((BooleanAttribute)result.getAttributeValue()).getValue()) continue;
                            return result;
                        }
                    }
                }
            }
            return new EvaluationResult(BooleanAttribute.getInstance(false));
        }
        return null;
    }

    private EvaluationResult getEvaluationResult(EvaluationCtx context, Function function, AttributeValue val1, AttributeValue val2, boolean isAllFunction) {
        ArrayList<Evaluatable> params = new ArrayList<Evaluatable>();
        params.add(val1);
        params.add(val2);
        EvaluationResult result = function.evaluate(params, context);
        if (result.indeterminate()) {
            return result;
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue() != isAllFunction) {
            return result;
        }
        return null;
    }

    @Override
    public URI getIdentifier() {
        return this.identifier;
    }

    @Override
    public URI getType() {
        return this.getReturnType();
    }

    @Override
    public URI getReturnType() {
        if (earlyException != null) {
            throw earlyException;
        }
        return returnTypeURI;
    }

    @Override
    public boolean returnsBag() {
        return false;
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Function FunctionId=\"").append(this.getIdentifier().toString()).append("\"/>\n");
    }

    static {
        try {
            returnTypeURI = new URI("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (URISyntaxException e) {
            earlyException = new IllegalArgumentException(e);
        }
        HashMap<String, Integer> nameIdMap = new HashMap<String, Integer>();
        nameIdMap.put(NAME_ANY_OF, 0);
        nameIdMap.put(NAME_ALL_OF, 1);
        nameIdMap.put(NAME_ANY_OF_ANY, 2);
        ID_MAP = Collections.unmodifiableMap(nameIdMap);
    }
}

