/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.wso2.balana.attr.AnyURIAttribute;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.DNSNameAttribute;
import org.wso2.balana.attr.IPAddressAttribute;
import org.wso2.balana.attr.RFC822NameAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.attr.X500NameAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;

public class MatchFunction
extends FunctionBase {
    public static final String NAME_REGEXP_STRING_MATCH = "urn:oasis:names:tc:xacml:1.0:function:regexp-string-match";
    public static final String NAME_X500NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:x500Name-match";
    public static final String NAME_RFC822NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:rfc822Name-match";
    public static final String NAME_STRING_REGEXP_MATCH = "urn:oasis:names:tc:xacml:1.0:function:string-regexp-match";
    public static final String NAME_ANYURI_REGEXP_MATCH = "urn:oasis:names:tc:xacml:2.0:function:anyURI-regexp-match";
    public static final String NAME_IPADDRESS_REGEXP_MATCH = "urn:oasis:names:tc:xacml:2.0:function:ipAddress-regexp-match";
    public static final String NAME_DNSNAME_REGEXP_MATCH = "urn:oasis:names:tc:xacml:2.0:function:dnsName-regexp-match";
    public static final String NAME_RFC822NAME_REGEXP_MATCH = "urn:oasis:names:tc:xacml:2.0:function:rfc822Name-regexp-match";
    public static final String NAME_X500NAME_REGEXP_MATCH = "urn:oasis:names:tc:xacml:2.0:function:x500Name-regexp-match";
    private static final int ID_REGEXP_STRING_MATCH = 0;
    private static final int ID_X500NAME_MATCH = 1;
    private static final int ID_RFC822NAME_MATCH = 2;
    private static final int ID_STRING_REGEXP_MATCH = 3;
    private static final int ID_ANYURI_REGEXP_MATCH = 4;
    private static final int ID_IPADDRESS_REGEXP_MATCH = 5;
    private static final int ID_DNSNAME_REGEXP_MATCH = 6;
    private static final int ID_RFC822NAME_REGEXP_MATCH = 7;
    private static final int ID_X500NAME_REGEXP_MATCH = 8;
    private static final String[] regexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string"};
    private static final String[] x500Params = new String[]{"urn:oasis:names:tc:xacml:1.0:data-type:x500Name", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name"};
    private static final String[] rfc822Params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name"};
    private static final String[] stringRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string"};
    private static final String[] anyURIRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anyURI"};
    private static final String[] ipAddressRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:2.0:data-type:ipAddress"};
    private static final String[] dnsNameRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:2.0:data-type:dnsName"};
    private static final String[] rfc822NameRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name"};
    private static final String[] x500NameRegexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name"};
    private static final boolean[] bagParams = new boolean[]{false, false};

    public MatchFunction(String functionName) {
        super(functionName, MatchFunction.getId(functionName), MatchFunction.getArgumentTypes(functionName), bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_REGEXP_STRING_MATCH)) {
            return 0;
        }
        if (functionName.equals(NAME_X500NAME_MATCH)) {
            return 1;
        }
        if (functionName.equals(NAME_RFC822NAME_MATCH)) {
            return 2;
        }
        if (functionName.equals(NAME_STRING_REGEXP_MATCH)) {
            return 3;
        }
        if (functionName.equals(NAME_ANYURI_REGEXP_MATCH)) {
            return 4;
        }
        if (functionName.equals(NAME_IPADDRESS_REGEXP_MATCH)) {
            return 5;
        }
        if (functionName.equals(NAME_DNSNAME_REGEXP_MATCH)) {
            return 6;
        }
        if (functionName.equals(NAME_RFC822NAME_REGEXP_MATCH)) {
            return 7;
        }
        if (functionName.equals(NAME_X500NAME_REGEXP_MATCH)) {
            return 8;
        }
        throw new IllegalArgumentException("unknown match function: " + functionName);
    }

    private static String[] getArgumentTypes(String functionName) {
        if (functionName.equals(NAME_REGEXP_STRING_MATCH)) {
            return regexpParams;
        }
        if (functionName.equals(NAME_X500NAME_MATCH)) {
            return x500Params;
        }
        if (functionName.equals(NAME_RFC822NAME_MATCH)) {
            return rfc822Params;
        }
        if (functionName.equals(NAME_STRING_REGEXP_MATCH)) {
            return stringRegexpParams;
        }
        if (functionName.equals(NAME_ANYURI_REGEXP_MATCH)) {
            return anyURIRegexpParams;
        }
        if (functionName.equals(NAME_IPADDRESS_REGEXP_MATCH)) {
            return ipAddressRegexpParams;
        }
        if (functionName.equals(NAME_DNSNAME_REGEXP_MATCH)) {
            return dnsNameRegexpParams;
        }
        if (functionName.equals(NAME_RFC822NAME_REGEXP_MATCH)) {
            return rfc822NameRegexpParams;
        }
        if (functionName.equals(NAME_X500NAME_REGEXP_MATCH)) {
            return x500NameRegexpParams;
        }
        return null;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_REGEXP_STRING_MATCH);
        set.add(NAME_X500NAME_MATCH);
        set.add(NAME_RFC822NAME_MATCH);
        set.add(NAME_STRING_REGEXP_MATCH);
        set.add(NAME_ANYURI_REGEXP_MATCH);
        set.add(NAME_IPADDRESS_REGEXP_MATCH);
        set.add(NAME_DNSNAME_REGEXP_MATCH);
        set.add(NAME_RFC822NAME_MATCH);
        set.add(NAME_X500NAME_MATCH);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        boolean boolResult = false;
        switch (this.getFunctionId()) {
            case 0: 
            case 3: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((StringAttribute)argValues[1]).getValue();
                if (context.isSearching() && arg1.equals("Any")) {
                    boolResult = true;
                    break;
                }
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
            case 1: {
                X500Principal arg0 = ((X500NameAttribute)argValues[0]).getValue();
                X500Principal arg1 = ((X500NameAttribute)argValues[1]).getValue();
                boolResult = arg1.getName("CANONICAL").endsWith(arg0.getName("CANONICAL"));
                break;
            }
            case 2: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((RFC822NameAttribute)argValues[1]).getValue();
                if (arg0.indexOf(64) != -1) {
                    String normalized = new RFC822NameAttribute(arg0).getValue();
                    boolResult = normalized.equals(arg1);
                    break;
                }
                if (arg0.charAt(0) == '.') {
                    boolResult = arg1.endsWith(arg0.toLowerCase());
                    break;
                }
                String mailDomain = arg1.substring(arg1.indexOf(64) + 1);
                boolResult = arg0.toLowerCase().equals(mailDomain);
                break;
            }
            case 4: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((AnyURIAttribute)argValues[1]).encode();
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
            case 5: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((IPAddressAttribute)argValues[1]).encode();
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
            case 6: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((DNSNameAttribute)argValues[1]).encode();
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
            case 7: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((RFC822NameAttribute)argValues[1]).encode();
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
            case 8: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((X500NameAttribute)argValues[1]).encode();
                boolResult = this.regexpHelper(arg0, arg1);
                break;
            }
        }
        return EvaluationResult.getInstance(boolResult);
    }

    private boolean regexpHelper(String xpr, String str) {
        StringBuffer buf = new StringBuffer(xpr);
        if (xpr.charAt(0) != '^') {
            buf = buf.insert(0, ".*");
        }
        if (xpr.charAt(xpr.length() - 1) != '$') {
            buf = buf.insert(buf.length(), ".*");
        }
        int idx = -1;
        idx = buf.indexOf("\\p{Is", 0);
        while (idx != -1) {
            buf = buf.replace(idx, idx + 5, "\\p{In");
            idx = buf.indexOf("\\p{Is", idx);
        }
        idx = -1;
        idx = buf.indexOf("\\P{Is", 0);
        while (idx != -1) {
            buf = buf.replace(idx, idx + 5, "\\P{In");
            idx = buf.indexOf("\\P{Is", idx);
        }
        idx = -1;
        idx = buf.indexOf("-[", 0);
        while (idx != -1) {
            buf = buf.replace(idx, idx + 2, "&&[^");
            idx = buf.indexOf("-[", idx);
        }
        return Pattern.matches(buf.toString(), str);
    }
}

