/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.IntegerAttribute;
import org.wso2.balana.cond.BagFunction;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;

public class GeneralBagFunction
extends BagFunction {
    private static final int ID_BASE_ONE_AND_ONLY = 0;
    private static final int ID_BASE_BAG_SIZE = 1;
    private static final int ID_BASE_BAG = 2;
    private static HashMap paramMap;
    private static Set supportedIds;

    public GeneralBagFunction(String functionName) {
        super(functionName, GeneralBagFunction.getId(functionName), GeneralBagFunction.getArgumentType(functionName), GeneralBagFunction.getIsBag(functionName), GeneralBagFunction.getNumArgs(functionName), GeneralBagFunction.getReturnType(functionName), GeneralBagFunction.getReturnsBag(functionName));
    }

    public GeneralBagFunction(String functionName, String datatype, String functionType) {
        super(functionName, GeneralBagFunction.getId(functionType), datatype, GeneralBagFunction.getIsBag(functionType), GeneralBagFunction.getNumArgs(functionType), GeneralBagFunction.getCustomReturnType(functionType, datatype), GeneralBagFunction.getReturnsBag(functionType));
    }

    private static int getId(String functionName) {
        BagParameters params = (BagParameters)paramMap.get(functionName);
        if (params == null) {
            throw new IllegalArgumentException("unknown bag function: " + functionName);
        }
        return params.id;
    }

    private static String getArgumentType(String functionName) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionName)).arg;
    }

    private static boolean getIsBag(String functionName) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionName)).argIsBag;
    }

    private static int getNumArgs(String functionName) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionName)).params;
    }

    private static String getReturnType(String functionName) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionName)).returnType;
    }

    private static boolean getReturnsBag(String functionName) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionName)).returnsBag;
    }

    private static String getCustomReturnType(String functionType, String datatype) {
        String ret = ((BagParameters)GeneralBagFunction.paramMap.get((Object)functionType)).returnType;
        if (ret == null) {
            return datatype;
        }
        return ret;
    }

    public static Set getSupportedIdentifiers() {
        return supportedIds;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        AttributeValue attrResult = null;
        switch (this.getFunctionId()) {
            case 0: {
                BagAttribute bag = (BagAttribute)argValues[0];
                if (bag.size() != 1) {
                    return GeneralBagFunction.makeProcessingError(this.getFunctionName() + " expects a bag that contains a single element, got a bag with " + bag.size() + " elements");
                }
                attrResult = (AttributeValue)bag.iterator().next();
                break;
            }
            case 1: {
                BagAttribute bag = (BagAttribute)argValues[0];
                attrResult = new IntegerAttribute(bag.size());
                break;
            }
            case 2: {
                List<AttributeValue> argsList = Arrays.asList(argValues);
                attrResult = new BagAttribute(this.getReturnType(), argsList);
                break;
            }
        }
        return new EvaluationResult(attrResult);
    }

    @Override
    public final boolean returnsBag() {
        return GeneralBagFunction.getReturnsBag(this.getFunctionName());
    }

    static {
        String functionBaseName;
        String baseType;
        int i;
        paramMap = new HashMap();
        for (i = 0; i < baseTypes.length; ++i) {
            baseType = baseTypes[i];
            functionBaseName = "urn:oasis:names:tc:xacml:1.0:function:" + simpleTypes[i];
            paramMap.put(functionBaseName + "-one-and-only", new BagParameters(0, baseType, true, 1, baseType, false));
            paramMap.put(functionBaseName + "-bag-size", new BagParameters(1, baseType, true, 1, "http://www.w3.org/2001/XMLSchema#integer", false));
            paramMap.put(functionBaseName + "-bag", new BagParameters(2, baseType, false, -1, baseType, true));
        }
        for (i = 0; i < baseTypes2.length; ++i) {
            baseType = baseTypes2[i];
            functionBaseName = "urn:oasis:names:tc:xacml:2.0:function:" + simpleTypes2[i];
            paramMap.put(functionBaseName + "-one-and-only", new BagParameters(0, baseType, true, 1, baseType, false));
            paramMap.put(functionBaseName + "-bag-size", new BagParameters(1, baseType, true, 1, "http://www.w3.org/2001/XMLSchema#integer", false));
            paramMap.put(functionBaseName + "-bag", new BagParameters(2, baseType, false, -1, baseType, true));
        }
        supportedIds = Collections.unmodifiableSet(new HashSet(paramMap.keySet()));
        paramMap.put("-one-and-only", new BagParameters(0, null, true, 1, null, false));
        paramMap.put("-bag-size", new BagParameters(1, null, true, 1, "http://www.w3.org/2001/XMLSchema#integer", false));
        paramMap.put("-bag", new BagParameters(2, null, false, -1, null, true));
    }

    private static class BagParameters {
        public int id;
        public String arg;
        public boolean argIsBag;
        public int params;
        public String returnType;
        public boolean returnsBag;

        public BagParameters(int id, String arg, boolean argIsBag, int params, String returnType, boolean returnsBag) {
            this.id = id;
            this.arg = arg;
            this.argIsBag = argIsBag;
            this.params = params;
            this.returnType = returnType;
            this.returnsBag = returnsBag;
        }
    }
}

