/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import org.w3c.dom.Node;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeDesignatorFactory;
import org.wso2.balana.attr.AttributeSelectorFactory;
import org.wso2.balana.cond.Apply;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.FunctionFactory;
import org.wso2.balana.cond.FunctionTypeException;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.cond.VariableReference;

public class ExpressionHandler {
    public static Expression parseExpression(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String name = DOMHelper.getLocalName(root);
        if (name.equals("Apply")) {
            return Apply.getInstance(root, metaData, manager);
        }
        if (name.equals("AttributeValue")) {
            try {
                return Balana.getInstance().getAttributeFactory().createValue(root);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown DataType", uie);
            }
        }
        if ("AttributeDesignator".equals(name)) {
            return AttributeDesignatorFactory.getFactory().getAbstractDesignator(root, metaData);
        }
        if (name.equals("SubjectAttributeDesignator")) {
            return AttributeDesignatorFactory.getFactory().getAbstractDesignator(root, metaData);
        }
        if (name.equals("ResourceAttributeDesignator")) {
            return AttributeDesignatorFactory.getFactory().getAbstractDesignator(root, metaData);
        }
        if (name.equals("ActionAttributeDesignator")) {
            return AttributeDesignatorFactory.getFactory().getAbstractDesignator(root, metaData);
        }
        if (name.equals("EnvironmentAttributeDesignator")) {
            return AttributeDesignatorFactory.getFactory().getAbstractDesignator(root, metaData);
        }
        if (name.equals("AttributeSelector")) {
            return AttributeSelectorFactory.getFactory().getAbstractSelector(root, metaData);
        }
        if (name.equals("Function")) {
            return ExpressionHandler.getFunction(root, metaData, FunctionFactory.getGeneralInstance());
        }
        if (name.equals("VariableReference")) {
            return VariableReference.getInstance(root, metaData, manager);
        }
        return null;
    }

    public static Function getFunction(Node root, PolicyMetaData metaData, FunctionFactory factory) throws ParsingException {
        String functionName;
        try {
            Node functionNode = root.getAttributes().getNamedItem("FunctionId");
            functionName = functionNode.getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required FunctionId in FunctionType", e);
        }
        try {
            return factory.createFunction(functionName);
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown FunctionId", uie);
        }
        catch (FunctionTypeException fte) {
            try {
                FunctionFactory ff = FunctionFactory.getGeneralInstance();
                return ff.createAbstractFunction(functionName, root, metaData.getXPathIdentifier());
            }
            catch (Exception e) {
                throw new ParsingException("failed to create abstract function " + functionName, e);
            }
        }
    }
}

