/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.ExpressionHandler;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.FunctionFactory;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.ctx.EvaluationCtx;

public class Apply
implements Evaluatable {
    private Function function;
    private List xprs;

    public Apply(Function function, List xprs) throws IllegalArgumentException {
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public Apply(Function function, List xprs, boolean isCondition) throws IllegalArgumentException {
        if (isCondition) {
            throw new IllegalArgumentException("As of version 2.0 an Apply may not represent a Condition");
        }
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public static Apply getConditionInstance(Node root, String xpathVersion, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), manager);
    }

    public static Apply getConditionInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Apply getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), metaData, manager);
    }

    public static Apply getInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    private static Apply getInstance(Node root, FunctionFactory factory, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        Function function = ExpressionHandler.getFunction(root, metaData, factory);
        ArrayList<Expression> xprs = new ArrayList<Expression>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Expression xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            if (xpr == null) continue;
            xprs.add(xpr);
        }
        return new Apply(function, xprs);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List getChildren() {
        return this.xprs;
    }

    public boolean isCondition() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return this.function.evaluate(this.xprs, context);
    }

    @Override
    public URI getType() {
        return this.function.getReturnType();
    }

    @Override
    public boolean returnsBag() {
        return this.function.returnsBag();
    }

    @Override
    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<Apply FunctionId=\"").append(this.function.getIdentifier()).append("\">\n");
        for (Expression xpr : this.xprs) {
            xpr.encode(builder);
        }
        builder.append("</Apply>\n");
    }
}

