/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.ResultFactory;
import org.wso2.balana.xacml3.Advice;

public class PermitUnlessDenyPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-unless-deny";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public PermitUnlessDenyPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public PermitUnlessDenyPolicyAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public AbstractResult combine(EvaluationCtx context, List parameters, List policyElements) {
        ArrayList<ObligationResult> permitObligations = new ArrayList<ObligationResult>();
        ArrayList<Advice> permitAdvices = new ArrayList<Advice>();
        for (Object policyElement : policyElements) {
            AbstractPolicy policy = ((PolicyCombinerElement)policyElement).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() != 0) continue;
            AbstractResult result = policy.evaluate(context);
            int value = result.getDecision();
            if (value == 1) {
                return result;
            }
            if (value != 0) continue;
            permitObligations.addAll(result.getObligations());
            permitAdvices.addAll(result.getAdvices());
        }
        return ResultFactory.getFactory().getResult(0, permitObligations, permitAdvices, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

