/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.ResultFactory;
import org.wso2.balana.xacml3.Advice;

public class DenyOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public DenyOverridesPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected DenyOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public AbstractResult combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOneErrorD = false;
        boolean atLeastOneErrorP = false;
        boolean atLeastOneErrorDP = false;
        boolean atLeastOnePermit = false;
        AbstractResult firstIndeterminateResultD = null;
        AbstractResult firstIndeterminateResultP = null;
        AbstractResult firstIndeterminateResultDP = null;
        ArrayList<ObligationResult> permitObligations = new ArrayList<ObligationResult>();
        ArrayList<Advice> permitAdvices = new ArrayList<Advice>();
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                return ResultFactory.getFactory().getResult(1, context);
            }
            if (match.getResult() != 0) continue;
            AbstractResult result = policy.evaluate(context);
            int value = result.getDecision();
            if (value == 1) {
                return result;
            }
            if (value == 3) continue;
            if (value == 0) {
                atLeastOnePermit = true;
                permitAdvices.addAll(result.getAdvices());
                permitObligations.addAll(result.getObligations());
                continue;
            }
            if (value == 4) {
                atLeastOneErrorD = true;
                if (firstIndeterminateResultD != null) continue;
                firstIndeterminateResultD = result;
                continue;
            }
            if (value == 5) {
                atLeastOneErrorP = true;
                if (firstIndeterminateResultP != null) continue;
                firstIndeterminateResultP = result;
                continue;
            }
            if (value != 6) continue;
            atLeastOneErrorDP = true;
            if (firstIndeterminateResultDP != null) continue;
            firstIndeterminateResultDP = result;
        }
        if (atLeastOneErrorDP) {
            return firstIndeterminateResultDP;
        }
        if (atLeastOneErrorD && atLeastOneErrorP && atLeastOnePermit) {
            return ResultFactory.getFactory().getResult(6, firstIndeterminateResultD.getStatus(), context);
        }
        if (atLeastOneErrorD) {
            return firstIndeterminateResultD;
        }
        if (atLeastOnePermit) {
            return ResultFactory.getFactory().getResult(0, permitObligations, permitAdvices, context);
        }
        if (atLeastOneErrorP) {
            return firstIndeterminateResultP;
        }
        return ResultFactory.getFactory().getResult(3, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

