/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.combine.BaseCombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgorithm;
import org.wso2.balana.combine.xacml2.FirstApplicablePolicyAlg;
import org.wso2.balana.combine.xacml2.FirstApplicableRuleAlg;
import org.wso2.balana.combine.xacml2.OnlyOneApplicablePolicyAlg;
import org.wso2.balana.combine.xacml2.OrderedDenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.OrderedPermitOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.PermitOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.PermitOverridesRuleAlg;
import org.wso2.balana.combine.xacml3.DenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml3.DenyOverridesRuleAlg;
import org.wso2.balana.combine.xacml3.DenyUnlessPermitPolicyAlg;
import org.wso2.balana.combine.xacml3.DenyUnlessPermitRuleAlg;
import org.wso2.balana.combine.xacml3.OrderedDenyOverridesRuleAlg;
import org.wso2.balana.combine.xacml3.OrderedPermitOverridesRuleAlg;
import org.wso2.balana.combine.xacml3.PermitUnlessDenyPolicyAlg;
import org.wso2.balana.combine.xacml3.PermitUnlessDenyRuleAlg;

public class StandardCombiningAlgFactory
extends BaseCombiningAlgFactory {
    private static volatile StandardCombiningAlgFactory factoryInstance = null;
    private static Set supportedAlgorithms = null;
    private static Set supportedAlgIds;
    private static final Log logger;

    private StandardCombiningAlgFactory() {
        super(supportedAlgorithms);
    }

    private static void initAlgorithms() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing standard combining algorithms");
        }
        supportedAlgorithms = new HashSet();
        supportedAlgIds = new HashSet();
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml2.DenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml2.DenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml2.OrderedDenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:rule-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:policy-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new PermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new PermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml2.OrderedPermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:rule-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:policy-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new FirstApplicableRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new FirstApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new OnlyOneApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable");
        supportedAlgorithms.add(new DenyUnlessPermitRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:deny-unless-permit");
        supportedAlgorithms.add(new DenyUnlessPermitPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-unless-permit");
        supportedAlgorithms.add(new PermitUnlessDenyRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:permit-unless-deny");
        supportedAlgorithms.add(new PermitUnlessDenyPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-unless-deny");
        supportedAlgorithms.add(new DenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new DenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml3.OrderedDenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml3.PermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml3.PermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new org.wso2.balana.combine.xacml3.OrderedPermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:ordered-permit-overrides");
        supportedAlgIds = Collections.unmodifiableSet(supportedAlgIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardCombiningAlgFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<StandardCombiningAlgFactory> clazz = StandardCombiningAlgFactory.class;
        synchronized (StandardCombiningAlgFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            StandardCombiningAlgFactory.initAlgorithms();
            factoryInstance = new StandardCombiningAlgFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }

    public static CombiningAlgFactory getNewFactory() {
        StandardCombiningAlgFactory.getFactory();
        return new BaseCombiningAlgFactory(supportedAlgorithms);
    }

    public static Set getStandardAlgorithms(String xacmlVersion) throws UnknownIdentifierException {
        if (xacmlVersion.equals("urn:oasis:names:tc:xacml:1.0:policy") || xacmlVersion.equals("urn:oasis:names:tc:xacml:2.0:policy:schema:os") || xacmlVersion.equals("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            return supportedAlgIds;
        }
        throw new UnknownIdentifierException("Unknown XACML version: " + xacmlVersion);
    }

    @Override
    public void addAlgorithm(CombiningAlgorithm alg) {
        throw new UnsupportedOperationException("a standard factory cannot support new algorithms");
    }

    static {
        logger = LogFactory.getLog(StandardCombiningAlgFactory.class);
    }
}

