/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr.xacml3;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.attr.AbstractAttributeSelector;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;

public class AttributeSelector
extends AbstractAttributeSelector {
    private URI category;
    private URI contextSelectorId;
    private String path;
    private static final Log logger = LogFactory.getLog(AttributeSelector.class);

    public AttributeSelector(URI category, URI type, URI contextSelectorId, String path, boolean mustBePresent, String xpathVersion) {
        this.category = category;
        this.type = type;
        this.contextSelectorId = contextSelectorId;
        this.mustBePresent = mustBePresent;
        this.xpathVersion = xpathVersion;
        this.path = path;
    }

    public static AttributeSelector getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        URI category = null;
        URI type = null;
        URI contextSelectorId = null;
        String path = null;
        boolean mustBePresent = false;
        String xpathVersion = metaData.getXPathIdentifier();
        if (xpathVersion == null) {
            throw new ParsingException("An XPathVersion is required for any policies that use selectors");
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            category = new URI(attrs.getNamedItem("Category").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required Category attribute in AttributeSelector", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required DataType attribute in AttributeSelector", e);
        }
        try {
            path = attrs.getNamedItem("Path").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required Path attribute in AttributeSelector", e);
        }
        try {
            String stringValue = attrs.getNamedItem("MustBePresent").getNodeValue();
            mustBePresent = Boolean.parseBoolean(stringValue);
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required MustBePresent attribute in AttributeSelector", e);
        }
        try {
            Node node = attrs.getNamedItem("ContextSelectorId");
            if (node != null) {
                contextSelectorId = new URI(node.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required MustBePresent attribute in AttributeSelector", e);
        }
        return new AttributeSelector(category, type, contextSelectorId, path, mustBePresent, xpathVersion);
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = context.getAttribute(this.path, this.type, this.category, this.contextSelectorId, this.xpathVersion);
        if (!result.indeterminate()) {
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) {
                if (this.mustBePresent) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AttributeSelector failed to resolve a value for a required attribute: " + this.path));
                    }
                    ArrayList<String> code = new ArrayList<String>();
                    code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                    String message = "couldn't resolve XPath expression " + this.path + " for type " + this.type.toString();
                    return new EvaluationResult(new Status(code, message));
                }
                return result;
            }
            return result;
        }
        return result;
    }

    @Override
    public boolean evaluatesToBag() {
        return true;
    }

    @Override
    public List getChildren() {
        return null;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    @Override
    public void encode(StringBuilder builder) {
    }
}

