/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import org.w3c.dom.Node;
import org.wso2.balana.attr.AttributeValue;

public class StringAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#string";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;

    public StringAttribute(String value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = value == null ? "" : value;
    }

    public static StringAttribute getInstance(Node root) {
        Node node = root.getFirstChild();
        if (node == null) {
            return new StringAttribute("");
        }
        short type = node.getNodeType();
        if (type == 3 || type == 4 || type == 8) {
            return StringAttribute.getInstance(node.getNodeValue());
        }
        return null;
    }

    public static StringAttribute getInstance(String value) {
        return new StringAttribute(value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringAttribute)) {
            return false;
        }
        StringAttribute other = (StringAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "StringAttribute: \"" + this.value + "\"";
    }

    @Override
    public String encode() {
        return this.value;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

