/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

class Base64 {
    private static final char SPACE = ' ';
    private static final char ETX = '\u0004';
    private static final char VTAB = '\u000b';
    private static final char FF = '\f';
    private static final char HTAB = '\t';
    private static final char LF = '\n';
    private static final char ALTLF = '\u0013';
    private static final char CR = '\r';
    private static char PAD = (char)61;
    private static final String BASE64EncodingString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/= \u0004\u000b\f\t\n\u0013\r";
    private static final int PAD_INDEX = 64;
    private static final int MAX_BASE64_CHAR = 122;
    private static int[] Base64DecodeArray = null;
    private static final int NO_CHARS_DECODED = 0;
    private static final int ONE_CHAR_DECODED = 1;
    private static final int TWO_CHARS_DECODED = 2;
    private static final int THREE_CHARS_DECODED = 3;
    private static final int PAD_THREE_READ = 5;
    private static final int PAD_FOUR_READ = 6;
    private static final int MAX_GROUPS_PER_LINE = 19;

    Base64() {
    }

    public static String encode(byte[] binaryValue) {
        int binaryValueLen = binaryValue.length;
        int maxChars = binaryValueLen * 7 / 5;
        StringBuffer sb = new StringBuffer(maxChars);
        int groupsToEOL = 19;
        for (int binaryValueNdx = 0; binaryValueNdx < binaryValueLen; binaryValueNdx += 3) {
            int group3;
            int group1 = binaryValue[binaryValueNdx] >> 2 & 0x3F;
            sb.append(BASE64EncodingString.charAt(group1));
            int group2 = binaryValue[binaryValueNdx] << 4 & 0x30;
            if (binaryValueNdx + 1 < binaryValueLen) {
                group2 |= binaryValue[binaryValueNdx + 1] >> 4 & 0xF;
            }
            sb.append(BASE64EncodingString.charAt(group2));
            if (binaryValueNdx + 1 < binaryValueLen) {
                group3 = binaryValue[binaryValueNdx + 1] << 2 & 0x3C;
                if (binaryValueNdx + 2 < binaryValueLen) {
                    group3 |= binaryValue[binaryValueNdx + 2] >> 6 & 3;
                }
            } else {
                group3 = 64;
            }
            sb.append(BASE64EncodingString.charAt(group3));
            int group4 = binaryValueNdx + 2 < binaryValueLen ? binaryValue[binaryValueNdx + 2] & 0x3F : 64;
            sb.append(BASE64EncodingString.charAt(group4));
            if (--groupsToEOL != 0) continue;
            groupsToEOL = 19;
            if (binaryValueNdx + 3 > binaryValueLen) continue;
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void initDecodeArray() {
        if (Base64DecodeArray != null) {
            return;
        }
        int[] ourArray = new int[123];
        for (int i = 0; i <= 122; ++i) {
            ourArray[i] = BASE64EncodingString.indexOf(i);
        }
        Base64DecodeArray = ourArray;
    }

    public static byte[] decode(String encoded, boolean ignoreBadChars) throws IOException {
        int encodedLen = encoded.length();
        int maxBytes = encodedLen / 4 * 3;
        ByteArrayOutputStream ba = new ByteArrayOutputStream(maxBytes);
        byte[] quantum = new byte[3];
        Base64.initDecodeArray();
        int state = 0;
        block8: for (int encodedNdx = 0; encodedNdx < encodedLen; ++encodedNdx) {
            char encodedChar = encoded.charAt(encodedNdx);
            int decodedChar = encodedChar > 'z' ? -1 : Base64DecodeArray[encodedChar];
            if (decodedChar == -1) {
                if (ignoreBadChars) continue;
                throw new IOException("Invalid character");
            }
            if (decodedChar > 64) continue;
            switch (state) {
                case 0: {
                    if (decodedChar == 64) {
                        throw new IOException("Pad character in invalid position");
                    }
                    quantum[0] = (byte)(decodedChar << 2 & 0xFC);
                    state = 1;
                    continue block8;
                }
                case 1: {
                    if (decodedChar == 64) {
                        throw new IOException("Pad character in invalid position");
                    }
                    quantum[0] = (byte)(quantum[0] | decodedChar >> 4 & 3);
                    quantum[1] = (byte)(decodedChar << 4 & 0xF0);
                    state = 2;
                    continue block8;
                }
                case 2: {
                    if (decodedChar == 64) {
                        ba.write(quantum, 0, 1);
                        state = 5;
                        continue block8;
                    }
                    quantum[1] = (byte)(quantum[1] | decodedChar >> 2 & 0xF);
                    quantum[2] = (byte)(decodedChar << 6 & 0xC0);
                    state = 3;
                    continue block8;
                }
                case 3: {
                    if (decodedChar == 64) {
                        ba.write(quantum, 0, 2);
                        state = 6;
                        continue block8;
                    }
                    quantum[2] = (byte)(quantum[2] | decodedChar);
                    ba.write(quantum, 0, 3);
                    state = 0;
                    continue block8;
                }
                case 5: {
                    if (decodedChar != 64) {
                        throw new IOException("Missing pad character");
                    }
                    state = 6;
                    continue block8;
                }
                case 6: {
                    throw new IOException("Invalid input follows pad character");
                }
            }
        }
        if (state != 0 && state != 6) {
            throw new IOException("Invalid sequence of input characters");
        }
        return ba.toByteArray();
    }
}

