/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;

public abstract class AttributeValue
implements Evaluatable {
    private URI type;

    protected AttributeValue(URI type) {
        this.type = type;
    }

    @Override
    public URI getType() {
        return this.type;
    }

    @Override
    public final boolean returnsBag() {
        return this.isBag();
    }

    @Override
    public final boolean evaluatesToBag() {
        return this.isBag();
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isBag() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return new EvaluationResult(this);
    }

    public abstract String encode();

    @Override
    public void encode(StringBuilder builder) {
        builder.append(this.encodeWithTags(true));
    }

    public String encodeWithTags(boolean includeType) {
        if (includeType && this.type != null) {
            return "<AttributeValue DataType=\"" + this.type.toString() + "\">" + this.encode() + "</AttributeValue>";
        }
        return "<AttributeValue>" + this.encode() + "</AttributeValue>";
    }
}

