/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactoryProxy;
import org.wso2.balana.attr.AttributeProxy;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.StandardAttributeFactory;

public abstract class AttributeFactory {
    private static AttributeFactoryProxy defaultFactoryProxy;
    private static HashMap registeredFactories;

    protected AttributeFactory() {
    }

    public static final AttributeFactory getInstance() {
        return defaultFactoryProxy.getFactory();
    }

    public static final AttributeFactory getInstance(String identifier) throws UnknownIdentifierException {
        AttributeFactoryProxy proxy = (AttributeFactoryProxy)registeredFactories.get(identifier);
        if (proxy == null) {
            throw new UnknownIdentifierException("Uknown AttributeFactory identifier: " + identifier);
        }
        return proxy.getFactory();
    }

    public static final void setDefaultFactory(AttributeFactoryProxy proxy) {
        defaultFactoryProxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerFactory(String identifier, AttributeFactoryProxy proxy) throws IllegalArgumentException {
        HashMap hashMap = registeredFactories;
        synchronized (hashMap) {
            if (registeredFactories.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier is already registered as AttributeFactory: " + identifier);
            }
            registeredFactories.put(identifier, proxy);
        }
    }

    public abstract void addDatatype(String var1, AttributeProxy var2);

    public abstract Set getSupportedDatatypes();

    public abstract AttributeValue createValue(Node var1) throws UnknownIdentifierException, ParsingException;

    public abstract AttributeValue createValue(Node var1, URI var2) throws UnknownIdentifierException, ParsingException;

    public abstract AttributeValue createValue(Node var1, String var2) throws UnknownIdentifierException, ParsingException;

    public AttributeValue createValue(URI dataType, String value) throws UnknownIdentifierException, ParsingException {
        return this.createValue(dataType, value, null);
    }

    public abstract AttributeValue createValue(URI var1, String var2, String[] var3) throws UnknownIdentifierException, ParsingException;

    static {
        AttributeFactoryProxy proxy = new AttributeFactoryProxy(){

            @Override
            public AttributeFactory getFactory() {
                return StandardAttributeFactory.getFactory();
            }
        };
        registeredFactories = new HashMap();
        registeredFactories.put("urn:oasis:names:tc:xacml:1.0:policy", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", proxy);
        defaultFactoryProxy = proxy;
    }
}

